/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.IOException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.shaded.com.google.common.base.Predicate;

public class FilteredRecordReader<E>
extends RecordReader<E, Void> {
    private RecordReader<E, Void> unfiltered;
    private Predicate<E> predicate;
    private E current;

    public FilteredRecordReader(RecordReader<E, Void> unfiltered, Constraints constraints, EntityAccessor<E> accessor) {
        this.unfiltered = unfiltered;
        this.predicate = constraints.toEntityPredicate(accessor);
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.unfiltered.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.current = this.computeNextKey();
        return this.current != null;
    }

    private E computeNextKey() throws IOException, InterruptedException {
        while (this.unfiltered.nextKeyValue()) {
            Object element = this.unfiltered.getCurrentKey();
            if (!this.predicate.apply(element)) continue;
            return (E)element;
        }
        return null;
    }

    public E getCurrentKey() throws IOException, InterruptedException {
        return this.current;
    }

    public Void getCurrentValue() throws IOException, InterruptedException {
        return (Void)this.unfiltered.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.unfiltered.getProgress();
    }

    public void close() throws IOException {
        this.unfiltered.close();
    }
}

