/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.hbase.avro.AvroRecordBuilder;
import org.kitesdk.data.hbase.avro.AvroRecordBuilderFactory;

public class GenericAvroRecordBuilderFactory
implements AvroRecordBuilderFactory<GenericRecord> {
    private final Schema recordSchema;

    public GenericAvroRecordBuilderFactory(Schema recordSchema) {
        this.recordSchema = recordSchema;
    }

    @Override
    public AvroRecordBuilder<GenericRecord> getBuilder() {
        return new GenericAvroRecordBuilder(this.recordSchema);
    }

    @Override
    public Class<GenericRecord> getRecordClass() {
        return GenericRecord.class;
    }

    private static class GenericAvroRecordBuilder
    implements AvroRecordBuilder<GenericRecord> {
        private final GenericRecord record;

        public GenericAvroRecordBuilder(Schema recordSchema) {
            this.record = new GenericData.Record(recordSchema);
        }

        @Override
        public void put(String field, Object value) {
            this.record.put(field, value);
        }

        @Override
        public GenericRecord build() {
            return this.record;
        }
    }
}

