/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import java.util.ArrayList;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionClient;
import org.hbase.async.RowLock;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class GetRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers {
    private static final byte[] GET = new byte[]{103, 101, 116};
    static final byte[] GGET = new byte[]{71, 101, 116};
    private static final byte[] EXISTS = new byte[]{101, 120, 105, 115, 116, 115};
    private byte[] family;
    private byte[][] qualifiers;
    private long lockid = -1L;
    private int versions = 2;
    private static final int EXIST_FLAG = 1;

    public GetRequest(byte[] table, byte[] key) {
        super(table, key);
    }

    public GetRequest(String table, byte[] key) {
        this(table.getBytes(), key);
    }

    public GetRequest(String table, String key) {
        this(table.getBytes(), key.getBytes());
    }

    public GetRequest(byte[] table, byte[] key, byte[] family) {
        super(table, key);
        this.family(family);
    }

    public GetRequest(String table, String key, String family) {
        this(table, key);
        this.family(family);
    }

    public GetRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        super(table, key);
        this.family(family);
        this.qualifier(qualifier);
    }

    public GetRequest(String table, String key, String family, String qualifier) {
        this(table, key);
        this.family(family);
        this.qualifier(qualifier);
    }

    private GetRequest(float unused, byte[] table, byte[] key) {
        super(table, key);
        this.versions |= 1;
    }

    static HBaseRpc exists(byte[] table, byte[] key) {
        return new GetRequest(0.0f, table, key);
    }

    static HBaseRpc exists(byte[] table, byte[] key, byte[] family) {
        GetRequest rpc = new GetRequest(0.0f, table, key);
        rpc.family(family);
        return rpc;
    }

    private boolean isGetRequest() {
        return (this.versions & 1) == 0;
    }

    public GetRequest family(byte[] family) {
        KeyValue.checkFamily(family);
        this.family = family;
        return this;
    }

    public GetRequest family(String family) {
        return this.family(family.getBytes());
    }

    public GetRequest qualifier(byte[] qualifier) {
        if (qualifier == null) {
            throw new NullPointerException("qualifier");
        }
        KeyValue.checkQualifier(qualifier);
        this.qualifiers = new byte[][]{qualifier};
        return this;
    }

    public GetRequest qualifiers(byte[][] qualifiers) {
        if (qualifiers == null) {
            throw new NullPointerException("qualifiers");
        }
        for (byte[] qualifier : qualifiers) {
            KeyValue.checkQualifier(qualifier);
        }
        this.qualifiers = qualifiers;
        return this;
    }

    public GetRequest qualifier(String qualifier) {
        return this.qualifier(qualifier.getBytes());
    }

    public GetRequest withRowLock(RowLock lock) {
        this.lockid = lock.id();
        return this;
    }

    public GetRequest maxVersions(int versions) {
        if (versions <= 0) {
            throw new IllegalArgumentException("Need a strictly positive number: " + versions);
        }
        this.versions = versions << 1 | this.versions & 1;
        return this;
    }

    public int maxVersions() {
        return this.versions >>> 1;
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version >= 95) {
            return GGET;
        }
        return this.isGetRequest() ? GET : EXISTS;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.family;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        String klass = this.isGetRequest() ? "GetRequest" : "Exists";
        return super.toStringWithQualifiers(klass, this.family, this.qualifiers);
    }

    private int predictSerializedSize(byte server_version) {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 4;
        ++size;
        if (server_version >= 26) {
            ++size;
        }
        size += 8;
        size += 8;
        ++size;
        size += 4;
        if (this.family != null) {
            ++size;
            size += this.family.length;
            ++size;
            if (this.qualifiers != null) {
                size += 4;
                for (byte[] qualifier : this.qualifiers) {
                    size += 3;
                    size += qualifier.length;
                }
            }
        }
        if (server_version >= 29) {
            size += 4;
        }
        return size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        int versions;
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.Get.Builder getpb = ClientPB.Get.newBuilder().setRow(Bytes.wrap(this.key));
        if (this.family != null) {
            ClientPB.Column.Builder column = ClientPB.Column.newBuilder();
            column.setFamily(Bytes.wrap(this.family));
            if (this.qualifiers != null) {
                for (byte[] qualifier : this.qualifiers) {
                    column.addQualifier(Bytes.wrap(qualifier));
                }
            }
            getpb.addColumn(column.build());
        }
        if ((versions = this.maxVersions()) != 1) {
            getpb.setMaxVersions(versions);
        }
        if (!this.isGetRequest()) {
            getpb.setExistenceOnly(true);
        }
        ClientPB.GetRequest.Builder get = ClientPB.GetRequest.newBuilder().setRegion(this.region.toProtobuf()).setGet(getpb.build());
        return GetRequest.toChannelBuffer(GGET, (AbstractMessageLite)get.build());
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize(server_version));
        buf.writeInt(2);
        GetRequest.writeHBaseByteArray(buf, this.region.name());
        buf.writeByte(32);
        buf.writeByte(32);
        buf.writeByte(1);
        GetRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.lockid);
        buf.writeInt(this.maxVersions());
        buf.writeByte(0);
        if (server_version >= 26) {
            buf.writeByte(1);
        }
        buf.writeLong(0L);
        buf.writeLong(Long.MAX_VALUE);
        buf.writeByte(1);
        buf.writeInt(this.family != null ? 1 : 0);
        if (this.family != null) {
            GetRequest.writeByteArray(buf, this.family);
            if (this.qualifiers != null) {
                buf.writeByte(1);
                buf.writeInt(this.qualifiers.length);
                for (byte[] qualifier : this.qualifiers) {
                    GetRequest.writeByteArray(buf, qualifier);
                }
            } else {
                buf.writeByte(0);
            }
        }
        if (server_version >= 29) {
            buf.writeInt(0);
        }
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        ClientPB.GetResponse resp = GetRequest.readProtobuf(buf, ClientPB.GetResponse.PARSER);
        if (this.isGetRequest()) {
            return GetRequest.extractResponse(resp, buf, cell_size);
        }
        ClientPB.Result result = resp.getResult();
        return result != null ? result.getExists() : false;
    }

    static ArrayList<KeyValue> extractResponse(ClientPB.GetResponse resp, ChannelBuffer buf, int cell_size) {
        ClientPB.Result res = resp.getResult();
        if (res == null) {
            return new ArrayList<KeyValue>(0);
        }
        return GetRequest.convertResult(res, buf, cell_size);
    }

    static ArrayList<KeyValue> convertResult(ClientPB.Result res, ChannelBuffer buf, int cell_size) {
        int i;
        int cell_kvs = RegionClient.numberOfKeyValuesAhead(buf, cell_size);
        int size = res.getCellCount();
        ArrayList<KeyValue> rows = new ArrayList<KeyValue>(size + cell_kvs);
        KeyValue kv = null;
        for (i = 0; i < size; ++i) {
            kv = KeyValue.fromCell(res.getCell(i), kv);
            rows.add(kv);
        }
        for (i = 0; i < cell_kvs; ++i) {
            int kv_length = buf.readInt();
            kv = KeyValue.fromBuffer(buf, kv);
            rows.add(kv);
        }
        return rows;
    }
}

