/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.sink;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ComponentConfigurationFactory;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.sink.SinkProcessorConfiguration;
import org.apache.flume.conf.sink.SinkProcessorType;

public class SinkGroupConfiguration
extends ComponentConfiguration {
    private Context processorContext;
    private List<String> sinks;
    private SinkProcessorConfiguration processorConf;

    public SinkGroupConfiguration(String name) {
        super(name);
        this.setType(ComponentConfiguration.ComponentType.SINKGROUP.getComponentType());
    }

    public void setSinks(List<String> sinks) {
        this.sinks = sinks;
    }

    public List<String> getSinks() {
        return this.sinks;
    }

    @Override
    public void configure(Context context) throws ConfigurationException {
        super.configure(context);
        this.sinks = Arrays.asList(context.getString("sinks").split("\\s+"));
        ImmutableMap<String, String> params = context.getSubProperties("processor.");
        this.processorContext = new Context();
        this.processorContext.putAll((Map<String, String>)params);
        SinkProcessorType spType = this.getKnownSinkProcessor(this.processorContext.getString("type"));
        if (spType != null) {
            this.processorConf = (SinkProcessorConfiguration)ComponentConfigurationFactory.create(this.getComponentName() + "-processor", spType.toString(), ComponentConfiguration.ComponentType.SINK_PROCESSOR);
            if (this.processorConf != null) {
                this.processorConf.setSinks(new HashSet<String>(this.sinks));
                this.processorConf.configure(this.processorContext);
            }
        }
        this.setConfigured();
    }

    public Context getProcessorContext() {
        return this.processorContext;
    }

    public void setProcessorContext(Context processorContext) {
        this.processorContext = processorContext;
    }

    public SinkProcessorConfiguration getSinkProcessorConfiguration() {
        return this.processorConf;
    }

    public void setSinkProcessorConfiguration(SinkProcessorConfiguration conf) {
        this.processorConf = conf;
    }

    private SinkProcessorType getKnownSinkProcessor(String type) {
        SinkProcessorType[] values;
        for (SinkProcessorType value : values = SinkProcessorType.values()) {
            if (value.toString().equalsIgnoreCase(type)) {
                return value;
            }
            String sinkProcessClassName = value.getSinkProcessorClassName();
            if (sinkProcessClassName == null || !sinkProcessClassName.equalsIgnoreCase(type)) continue;
            return value;
        }
        return null;
    }
}

