/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.DB;
import org.mapdb.Fun;
import org.mapdb.TxBlock;
import org.mapdb.TxEngine;
import org.mapdb.TxRollbackException;

public class TxMaker {
    protected static final Object DELETED = new Object();
    protected TxEngine engine;

    public TxMaker(TxEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        if (engine.isReadOnly()) {
            throw new IllegalArgumentException("read only");
        }
        if (!engine.canRollback()) {
            throw new IllegalArgumentException("no rollback");
        }
        this.engine = engine;
    }

    public DB makeTx() {
        return new DB(this.engine.snapshot());
    }

    public void close() {
        this.engine.close();
        this.engine = null;
    }

    public void execute(TxBlock txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                txBlock.tx(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return;
            }
            catch (TxRollbackException e) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }

    public <A> A execute(Fun.Function1<A, DB> txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                A a = txBlock.run(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return a;
            }
            catch (TxRollbackException e) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }
}

