/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.base.Preconditions;
import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.AbstractChannel;
import org.apache.flume.channel.BasicTransactionSemantics;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class BasicChannelSemantics
extends AbstractChannel {
    private ThreadLocal<BasicTransactionSemantics> currentTransaction = new ThreadLocal();
    private boolean initialized = false;

    protected void initialize() {
    }

    protected abstract BasicTransactionSemantics createTransaction();

    @Override
    public void put(Event event) throws ChannelException {
        BasicTransactionSemantics transaction = this.currentTransaction.get();
        Preconditions.checkState((transaction != null ? 1 : 0) != 0, (Object)"No transaction exists for this thread");
        transaction.put(event);
    }

    @Override
    public Event take() throws ChannelException {
        BasicTransactionSemantics transaction = this.currentTransaction.get();
        Preconditions.checkState((transaction != null ? 1 : 0) != 0, (Object)"No transaction exists for this thread");
        return transaction.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction getTransaction() {
        BasicTransactionSemantics transaction;
        if (!this.initialized) {
            BasicChannelSemantics basicChannelSemantics = this;
            synchronized (basicChannelSemantics) {
                if (!this.initialized) {
                    this.initialize();
                    this.initialized = true;
                }
            }
        }
        if ((transaction = this.currentTransaction.get()) == null || transaction.getState().equals((Object)BasicTransactionSemantics.State.CLOSED)) {
            transaction = this.createTransaction();
            this.currentTransaction.set(transaction);
        }
        return transaction;
    }
}

