/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.file.BadCheckpointException;
import org.apache.flume.channel.file.CheckpointRebuilder;
import org.apache.flume.channel.file.Commit;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.EventQueueBackingStore;
import org.apache.flume.channel.file.EventQueueBackingStoreFactory;
import org.apache.flume.channel.file.EventQueueBackingStoreFile;
import org.apache.flume.channel.file.FlumeEvent;
import org.apache.flume.channel.file.FlumeEventPointer;
import org.apache.flume.channel.file.FlumeEventQueue;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileFactory;
import org.apache.flume.channel.file.LogFileRetryableIOException;
import org.apache.flume.channel.file.LogUtils;
import org.apache.flume.channel.file.NoopRecordException;
import org.apache.flume.channel.file.Put;
import org.apache.flume.channel.file.ReplayHandler;
import org.apache.flume.channel.file.Rollback;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.Take;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.WriteOrderOracle;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Log {
    public static final String PREFIX = "log-";
    private static final Logger LOGGER = LoggerFactory.getLogger(Log.class);
    private static final int MIN_NUM_LOGS = 2;
    public static final String FILE_LOCK = "in_use.lock";
    private final Map<Integer, LogFile.RandomReader> idLogFileMap = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger nextFileID = new AtomicInteger(0);
    private final File checkpointDir;
    private final File backupCheckpointDir;
    private final File[] logDirs;
    private final int queueCapacity;
    private final AtomicReferenceArray<LogFile.Writer> logFiles;
    private final ScheduledExecutorService workerExecutor;
    private volatile boolean open;
    private FlumeEventQueue queue;
    private long checkpointInterval;
    private long maxFileSize;
    private final boolean useFastReplay;
    private final long minimumRequiredSpace;
    private final Map<String, FileLock> locks;
    private final ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock(true);
    public static final Set<String> EXCLUDES = Sets.newHashSet((Object[])new String[]{"in_use.lock"});
    private final ReentrantReadWriteLock.ReadLock checkpointReadLock = this.checkpointLock.readLock();
    private final ReentrantReadWriteLock.WriteLock checkpointWriterLock = this.checkpointLock.writeLock();
    private int logWriteTimeout;
    private final String channelNameDescriptor;
    private int checkpointWriteTimeout;
    private boolean useLogReplayV1;
    private KeyProvider encryptionKeyProvider;
    private String encryptionCipherProvider;
    private String encryptionKeyAlias;
    private Key encryptionKey;
    private final long usableSpaceRefreshInterval;
    private boolean didFastReplay = false;
    private boolean didFullReplayDueToBadCheckpointException = false;
    private final boolean useDualCheckpoints;
    private volatile boolean backupRestored = false;
    private int readCount;
    private int putCount;
    private int takeCount;
    private int committedCount;
    private int rollbackCount;
    private final List<File> pendingDeletes = Lists.newArrayList();

    private Log(long checkpointInterval, long maxFileSize, int queueCapacity, int logWriteTimeout, int checkpointWriteTimeout, boolean useDualCheckpoints, File checkpointDir, File backupCheckpointDir, String name, boolean useLogReplayV1, boolean useFastReplay, long minimumRequiredSpace, @Nullable KeyProvider encryptionKeyProvider, @Nullable String encryptionKeyAlias, @Nullable String encryptionCipherProvider, long usableSpaceRefreshInterval, File ... logDirs) throws IOException {
        Preconditions.checkArgument((checkpointInterval > 0L ? 1 : 0) != 0, (Object)"checkpointInterval <= 0");
        Preconditions.checkArgument((queueCapacity > 0 ? 1 : 0) != 0, (Object)"queueCapacity <= 0");
        Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (Object)"maxFileSize <= 0");
        Preconditions.checkNotNull((Object)checkpointDir, (Object)"checkpointDir");
        Preconditions.checkArgument((usableSpaceRefreshInterval > 0L ? 1 : 0) != 0, (Object)"usableSpaceRefreshInterval <= 0");
        Preconditions.checkArgument((checkpointDir.isDirectory() || checkpointDir.mkdirs() ? 1 : 0) != 0, (Object)("CheckpointDir " + checkpointDir + " could not be created"));
        if (useDualCheckpoints) {
            Preconditions.checkNotNull((Object)backupCheckpointDir, (Object)"backupCheckpointDir is null while dual checkpointing is enabled.");
            Preconditions.checkArgument((backupCheckpointDir.isDirectory() || backupCheckpointDir.mkdirs() ? 1 : 0) != 0, (Object)("Backup CheckpointDir " + backupCheckpointDir + " could not be created"));
        }
        Preconditions.checkNotNull((Object)logDirs, (Object)"logDirs");
        Preconditions.checkArgument((logDirs.length > 0 ? 1 : 0) != 0, (Object)"logDirs empty");
        Preconditions.checkArgument((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (Object)"channel name should be specified");
        this.channelNameDescriptor = "[channel=" + name + "]";
        this.useLogReplayV1 = useLogReplayV1;
        this.useFastReplay = useFastReplay;
        this.minimumRequiredSpace = minimumRequiredSpace;
        this.usableSpaceRefreshInterval = usableSpaceRefreshInterval;
        for (File logDir : logDirs) {
            Preconditions.checkArgument((logDir.isDirectory() || logDir.mkdirs() ? 1 : 0) != 0, (Object)("LogDir " + logDir + " could not be created"));
        }
        this.locks = Maps.newHashMap();
        try {
            this.lock(checkpointDir);
            if (useDualCheckpoints) {
                this.lock(backupCheckpointDir);
            }
            for (File logDir : logDirs) {
                this.lock(logDir);
            }
        }
        catch (IOException e) {
            this.unlock(checkpointDir);
            for (File logDir : logDirs) {
                this.unlock(logDir);
            }
            throw e;
        }
        if (encryptionKeyProvider != null && encryptionKeyAlias != null && encryptionCipherProvider != null) {
            LOGGER.info("Encryption is enabled with encryptionKeyProvider = " + encryptionKeyProvider + ", encryptionKeyAlias = " + encryptionKeyAlias + ", encryptionCipherProvider = " + encryptionCipherProvider);
            this.encryptionKeyProvider = encryptionKeyProvider;
            this.encryptionKeyAlias = encryptionKeyAlias;
            this.encryptionCipherProvider = encryptionCipherProvider;
            this.encryptionKey = encryptionKeyProvider.getKey(encryptionKeyAlias);
        } else if (encryptionKeyProvider == null && encryptionKeyAlias == null && encryptionCipherProvider == null) {
            LOGGER.info("Encryption is not enabled");
        } else {
            throw new IllegalArgumentException("Encryption configuration must all null or all not null: encryptionKeyProvider = " + encryptionKeyProvider + ", encryptionKeyAlias = " + encryptionKeyAlias + ", encryptionCipherProvider = " + encryptionCipherProvider);
        }
        this.open = false;
        this.checkpointInterval = Math.max(checkpointInterval, 1000L);
        this.maxFileSize = maxFileSize;
        this.queueCapacity = queueCapacity;
        this.useDualCheckpoints = useDualCheckpoints;
        this.checkpointDir = checkpointDir;
        this.backupCheckpointDir = backupCheckpointDir;
        this.logDirs = logDirs;
        this.logWriteTimeout = logWriteTimeout;
        this.checkpointWriteTimeout = checkpointWriteTimeout;
        this.logFiles = new AtomicReferenceArray(this.logDirs.length);
        this.workerExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Log-BackgroundWorker-" + name).build());
        this.workerExecutor.scheduleWithFixedDelay(new BackgroundWorker(this), this.checkpointInterval, this.checkpointInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replay() throws IOException {
        Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"Cannot replay after Log has been opened");
        Preconditions.checkState((boolean)this.tryLockExclusive(), (Object)("Cannot obtain lock on " + this.channelNameDescriptor));
        try {
            block18: {
                LOGGER.info("Replay started");
                this.nextFileID.set(0);
                ArrayList dataFiles = Lists.newArrayList();
                for (File logDir : this.logDirs) {
                    for (File file : LogUtils.getLogs(logDir)) {
                        int id = LogUtils.getIDForFile(file);
                        dataFiles.add(file);
                        this.nextFileID.set(Math.max(this.nextFileID.get(), id));
                        this.idLogFileMap.put(id, LogFileFactory.getRandomReader(new File(logDir, PREFIX + id), this.encryptionKeyProvider));
                    }
                }
                LOGGER.info("Found NextFileID " + this.nextFileID + ", from " + dataFiles);
                LogUtils.sort(dataFiles);
                boolean shouldFastReplay = this.useFastReplay;
                File checkpointFile = new File(this.checkpointDir, "checkpoint");
                if (shouldFastReplay) {
                    if (checkpointFile.exists()) {
                        LOGGER.debug("Disabling fast full replay because checkpoint exists: " + checkpointFile);
                        shouldFastReplay = false;
                    } else {
                        LOGGER.debug("Not disabling fast full replay because checkpoint  does not exist: " + checkpointFile);
                    }
                }
                File inflightTakesFile = new File(this.checkpointDir, "inflighttakes");
                File inflightPutsFile = new File(this.checkpointDir, "inflightputs");
                EventQueueBackingStore backingStore = null;
                try {
                    backingStore = EventQueueBackingStoreFactory.get(checkpointFile, this.backupCheckpointDir, this.queueCapacity, this.channelNameDescriptor, true, this.useDualCheckpoints);
                    this.queue = new FlumeEventQueue(backingStore, inflightTakesFile, inflightPutsFile);
                    LOGGER.info("Last Checkpoint " + new Date(checkpointFile.lastModified()) + ", queue depth = " + this.queue.getSize());
                    this.doReplay(this.queue, dataFiles, this.encryptionKeyProvider, shouldFastReplay);
                }
                catch (BadCheckpointException ex) {
                    this.backupRestored = false;
                    if (this.useDualCheckpoints) {
                        LOGGER.warn("Checkpoint may not have completed successfully. Restoring checkpoint and starting up.", (Throwable)((Object)ex));
                        if (EventQueueBackingStoreFile.backupExists(this.backupCheckpointDir)) {
                            this.backupRestored = EventQueueBackingStoreFile.restoreBackup(this.checkpointDir, this.backupCheckpointDir);
                        }
                    }
                    if (!this.backupRestored) {
                        LOGGER.warn("Checkpoint may not have completed successfully. Forcing full replay, this may take a while.", (Throwable)((Object)ex));
                        if (!Serialization.deleteAllFiles(this.checkpointDir, EXCLUDES)) {
                            throw new IOException("Could not delete files in checkpoint directory to recover from a corrupt or incomplete checkpoint");
                        }
                    }
                    backingStore = EventQueueBackingStoreFactory.get(checkpointFile, this.backupCheckpointDir, this.queueCapacity, this.channelNameDescriptor, true, this.useDualCheckpoints);
                    this.queue = new FlumeEventQueue(backingStore, inflightTakesFile, inflightPutsFile);
                    shouldFastReplay = this.useFastReplay;
                    this.doReplay(this.queue, dataFiles, this.encryptionKeyProvider, shouldFastReplay);
                    if (shouldFastReplay) break block18;
                    this.didFullReplayDueToBadCheckpointException = true;
                }
            }
            for (int index = 0; index < this.logDirs.length; ++index) {
                LOGGER.info("Rolling " + this.logDirs[index]);
                this.roll(index);
            }
            this.writeCheckpoint(true);
            this.open = true;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to initialize Log on " + this.channelNameDescriptor, (Throwable)ex);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            Throwables.propagate((Throwable)ex);
        }
        finally {
            this.unlockExclusive();
        }
    }

    private void doReplay(FlumeEventQueue queue, List<File> dataFiles, KeyProvider encryptionKeyProvider, boolean useFastReplay) throws Exception {
        CheckpointRebuilder rebuilder = new CheckpointRebuilder(dataFiles, queue);
        if (useFastReplay && rebuilder.rebuild()) {
            this.didFastReplay = true;
            LOGGER.info("Fast replay successful.");
        } else {
            ReplayHandler replayHandler = new ReplayHandler(queue, encryptionKeyProvider);
            if (this.useLogReplayV1) {
                LOGGER.info("Replaying logs with v1 replay logic");
                replayHandler.replayLogv1(dataFiles);
            } else {
                LOGGER.info("Replaying logs with v2 replay logic");
                replayHandler.replayLog(dataFiles);
            }
            this.readCount = replayHandler.getReadCount();
            this.putCount = replayHandler.getPutCount();
            this.takeCount = replayHandler.getTakeCount();
            this.rollbackCount = replayHandler.getRollbackCount();
            this.committedCount = replayHandler.getCommitCount();
        }
    }

    @VisibleForTesting
    boolean didFastReplay() {
        return this.didFastReplay;
    }

    @VisibleForTesting
    public int getReadCount() {
        return this.readCount;
    }

    @VisibleForTesting
    public int getPutCount() {
        return this.putCount;
    }

    @VisibleForTesting
    public int getTakeCount() {
        return this.takeCount;
    }

    @VisibleForTesting
    public int getCommittedCount() {
        return this.committedCount;
    }

    @VisibleForTesting
    public int getRollbackCount() {
        return this.rollbackCount;
    }

    @VisibleForTesting
    boolean backupRestored() {
        return this.backupRestored;
    }

    @VisibleForTesting
    boolean didFullReplayDueToBadCheckpointException() {
        return this.didFullReplayDueToBadCheckpointException;
    }

    int getNextFileID() {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        return this.nextFileID.get();
    }

    FlumeEventQueue getFlumeEventQueue() {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        return this.queue;
    }

    FlumeEvent get(FlumeEventPointer pointer) throws IOException, InterruptedException, NoopRecordException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        int id = pointer.getFileID();
        LogFile.RandomReader logFile = this.idLogFileMap.get(id);
        Preconditions.checkNotNull((Object)logFile, (Object)("LogFile is null for id " + id));
        try {
            return logFile.get(pointer.getOffset());
        }
        catch (CorruptEventException ex) {
            this.open = false;
            throw new IOException("Corrupt event found. Please run File Channel Integrity tool.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FlumeEventPointer put(long transactionID, Event event) throws IOException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        FlumeEvent flumeEvent = new FlumeEvent(event.getHeaders(), event.getBody());
        Put put = new Put(transactionID, WriteOrderOracle.next(), flumeEvent);
        ByteBuffer buffer = TransactionEventRecord.toByteBuffer(put);
        int logFileIndex = this.nextLogWriter(transactionID);
        long usableSpace = this.logFiles.get(logFileIndex).getUsableSpace();
        long requiredSpace = this.minimumRequiredSpace + (long)buffer.limit();
        if (usableSpace <= requiredSpace) {
            throw new IOException("Usable space exhaused, only " + usableSpace + " bytes remaining, required " + requiredSpace + " bytes");
        }
        boolean error = true;
        try {
            FlumeEventPointer ptr = this.logFiles.get(logFileIndex).put(buffer);
            error = false;
            FlumeEventPointer flumeEventPointer = ptr;
            return flumeEventPointer;
        }
        catch (LogFileRetryableIOException e) {
            if (!this.open) {
                throw e;
            }
            this.roll(logFileIndex, buffer);
            FlumeEventPointer ptr = this.logFiles.get(logFileIndex).put(buffer);
            error = false;
            FlumeEventPointer flumeEventPointer = ptr;
            return flumeEventPointer;
        }
        finally {
            if (error && this.open) {
                this.roll(logFileIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void take(long transactionID, FlumeEventPointer pointer) throws IOException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        Take take = new Take(transactionID, WriteOrderOracle.next(), pointer.getOffset(), pointer.getFileID());
        ByteBuffer buffer = TransactionEventRecord.toByteBuffer(take);
        int logFileIndex = this.nextLogWriter(transactionID);
        long usableSpace = this.logFiles.get(logFileIndex).getUsableSpace();
        long requiredSpace = this.minimumRequiredSpace + (long)buffer.limit();
        if (usableSpace <= requiredSpace) {
            throw new IOException("Usable space exhaused, only " + usableSpace + " bytes remaining, required " + requiredSpace + " bytes");
        }
        boolean error = true;
        try {
            try {
                this.logFiles.get(logFileIndex).take(buffer);
                error = false;
            }
            catch (LogFileRetryableIOException e) {
                if (!this.open) {
                    throw e;
                }
                this.roll(logFileIndex, buffer);
                this.logFiles.get(logFileIndex).take(buffer);
                error = false;
            }
        }
        finally {
            if (error && this.open) {
                this.roll(logFileIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(long transactionID) throws IOException {
        long requiredSpace;
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Rolling back " + transactionID);
        }
        Rollback rollback = new Rollback((Long)transactionID, (Long)WriteOrderOracle.next());
        ByteBuffer buffer = TransactionEventRecord.toByteBuffer(rollback);
        int logFileIndex = this.nextLogWriter(transactionID);
        long usableSpace = this.logFiles.get(logFileIndex).getUsableSpace();
        if (usableSpace <= (requiredSpace = this.minimumRequiredSpace + (long)buffer.limit())) {
            throw new IOException("Usable space exhaused, only " + usableSpace + " bytes remaining, required " + requiredSpace + " bytes");
        }
        boolean error = true;
        try {
            try {
                this.logFiles.get(logFileIndex).rollback(buffer);
                error = false;
            }
            catch (LogFileRetryableIOException e) {
                if (!this.open) {
                    throw e;
                }
                this.roll(logFileIndex, buffer);
                this.logFiles.get(logFileIndex).rollback(buffer);
                error = false;
            }
        }
        finally {
            if (error && this.open) {
                this.roll(logFileIndex);
            }
        }
    }

    void commitPut(long transactionID) throws IOException, InterruptedException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        this.commit(transactionID, TransactionEventRecord.Type.PUT.get());
    }

    void commitTake(long transactionID) throws IOException, InterruptedException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        this.commit(transactionID, TransactionEventRecord.Type.TAKE.get());
    }

    private boolean tryLockExclusive() {
        try {
            return this.checkpointWriterLock.tryLock(this.checkpointWriteTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Interrupted while waiting for log exclusive lock", (Throwable)ex);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void unlockExclusive() {
        this.checkpointWriterLock.unlock();
    }

    boolean tryLockShared() {
        try {
            return this.checkpointReadLock.tryLock(this.logWriteTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Interrupted while waiting for log shared lock", (Throwable)ex);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void unlockShared() {
        this.checkpointReadLock.unlock();
    }

    private void lockExclusive() {
        this.checkpointWriterLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        this.lockExclusive();
        try {
            this.open = false;
            this.shutdownWorker();
            if (this.logFiles != null) {
                for (int index = 0; index < this.logFiles.length(); ++index) {
                    LogFile.Writer writer = this.logFiles.get(index);
                    if (writer == null) continue;
                    writer.close();
                }
            }
            Map<Integer, LogFile.RandomReader> index = this.idLogFileMap;
            synchronized (index) {
                for (Integer logId : this.idLogFileMap.keySet()) {
                    LogFile.RandomReader reader = this.idLogFileMap.get(logId);
                    if (reader == null) continue;
                    reader.close();
                }
            }
            this.queue.close();
            try {
                this.unlock(this.checkpointDir);
            }
            catch (IOException ex) {
                LOGGER.warn("Error unlocking " + this.checkpointDir, (Throwable)ex);
            }
            if (this.useDualCheckpoints) {
                try {
                    this.unlock(this.backupCheckpointDir);
                }
                catch (IOException ex) {
                    LOGGER.warn("Error unlocking " + this.checkpointDir, (Throwable)ex);
                }
            }
            for (File logDir : this.logDirs) {
                try {
                    this.unlock(logDir);
                }
                catch (IOException ex) {
                    LOGGER.warn("Error unlocking " + logDir, (Throwable)ex);
                }
            }
        }
        finally {
            this.unlockExclusive();
        }
    }

    void shutdownWorker() {
        String msg = "Attempting to shutdown background worker.";
        System.out.println(msg);
        LOGGER.info(msg);
        this.workerExecutor.shutdown();
        try {
            this.workerExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for worker to die.");
        }
    }

    void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(long transactionID, short type) throws IOException {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        Commit commit = new Commit(transactionID, WriteOrderOracle.next(), type);
        ByteBuffer buffer = TransactionEventRecord.toByteBuffer(commit);
        int logFileIndex = this.nextLogWriter(transactionID);
        long usableSpace = this.logFiles.get(logFileIndex).getUsableSpace();
        long requiredSpace = this.minimumRequiredSpace + (long)buffer.limit();
        if (usableSpace <= requiredSpace) {
            throw new IOException("Usable space exhaused, only " + usableSpace + " bytes remaining, required " + requiredSpace + " bytes");
        }
        boolean error = true;
        try {
            try {
                LogFile.Writer logFileWriter = this.logFiles.get(logFileIndex);
                logFileWriter.commit(buffer);
                logFileWriter.sync();
                error = false;
            }
            catch (LogFileRetryableIOException e) {
                if (!this.open) {
                    throw e;
                }
                this.roll(logFileIndex, buffer);
                LogFile.Writer logFileWriter = this.logFiles.get(logFileIndex);
                logFileWriter.commit(buffer);
                logFileWriter.sync();
                error = false;
            }
        }
        finally {
            if (error && this.open) {
                this.roll(logFileIndex);
            }
        }
    }

    private int nextLogWriter(long transactionID) {
        return (int)Math.abs(transactionID % (long)this.logFiles.length());
    }

    private void roll(int index) throws IOException {
        this.roll(index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void roll(int index, ByteBuffer buffer) throws IOException {
        block8: {
            if (!this.tryLockShared()) {
                throw new ChannelException("Failed to obtain lock for writing to the log. Try increasing the log write timeout value. " + this.channelNameDescriptor);
            }
            try {
                LogFile.Writer oldLogFile = this.logFiles.get(index);
                if (oldLogFile != null && buffer != null && !oldLogFile.isRollRequired(buffer)) break block8;
                try {
                    LOGGER.info("Roll start " + this.logDirs[index]);
                    int fileID = this.nextFileID.incrementAndGet();
                    File file = new File(this.logDirs[index], PREFIX + fileID);
                    LogFile.Writer writer = LogFileFactory.getWriter(file, fileID, this.maxFileSize, this.encryptionKey, this.encryptionKeyAlias, this.encryptionCipherProvider, this.usableSpaceRefreshInterval);
                    this.idLogFileMap.put(fileID, LogFileFactory.getRandomReader(file, this.encryptionKeyProvider));
                    this.logFiles.set(index, writer);
                    if (oldLogFile != null) {
                        oldLogFile.close();
                    }
                }
                finally {
                    LOGGER.info("Roll end");
                }
            }
            finally {
                this.unlockShared();
            }
        }
    }

    private boolean writeCheckpoint() throws Exception {
        return this.writeCheckpoint(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean writeCheckpoint(Boolean force) throws Exception {
        TreeSet<Integer> logFileRefCountsActive;
        boolean checkpointCompleted;
        block15: {
            checkpointCompleted = false;
            long usableSpace = this.checkpointDir.getUsableSpace();
            if (usableSpace <= this.minimumRequiredSpace) {
                throw new IOException("Usable space exhaused, only " + usableSpace + " bytes remaining, required " + this.minimumRequiredSpace + " bytes");
            }
            boolean lockAcquired = this.tryLockExclusive();
            if (!lockAcquired) {
                return false;
            }
            SortedSet<Integer> logFileRefCountsAll = null;
            logFileRefCountsActive = null;
            try {
                LogFile.MetaDataWriter writer;
                if (!this.queue.checkpoint(force)) break block15;
                long logWriteOrderID = this.queue.getLogWriteOrderID();
                logFileRefCountsAll = this.queue.getFileIDs();
                logFileRefCountsActive = new TreeSet<Integer>(logFileRefCountsAll);
                int numFiles = this.logFiles.length();
                for (int i = 0; i < numFiles; ++i) {
                    LogFile.Writer logWriter = this.logFiles.get(i);
                    int logFileID = logWriter.getLogFileID();
                    File logFile = logWriter.getFile();
                    writer = LogFileFactory.getMetaDataWriter(logFile, logFileID);
                    try {
                        writer.markCheckpoint(logWriter.position(), logWriteOrderID);
                    }
                    finally {
                        writer.close();
                    }
                    logFileRefCountsAll.remove(logFileID);
                    LOGGER.info("Updated checkpoint for file: " + logFile + " position: " + logWriter.position() + " logWriteOrderID: " + logWriteOrderID);
                }
                Iterator idIterator = logFileRefCountsAll.iterator();
                while (idIterator.hasNext()) {
                    int id = (Integer)idIterator.next();
                    LogFile.RandomReader reader = this.idLogFileMap.remove(id);
                    File file = reader.getFile();
                    reader.close();
                    writer = LogFileFactory.getMetaDataWriter(file, id);
                    try {
                        writer.markCheckpoint(logWriteOrderID);
                    }
                    finally {
                        writer.close();
                    }
                    reader = LogFileFactory.getRandomReader(file, this.encryptionKeyProvider);
                    this.idLogFileMap.put(id, reader);
                    LOGGER.debug("Updated checkpoint for file: " + file + "logWriteOrderID " + logWriteOrderID);
                    idIterator.remove();
                }
                Preconditions.checkState((logFileRefCountsAll.size() == 0 ? 1 : 0) != 0, (Object)("Could not update all data file timestamps: " + logFileRefCountsAll));
                for (int index = 0; index < this.logDirs.length; ++index) {
                    logFileRefCountsActive.add(this.logFiles.get(index).getLogFileID());
                }
                checkpointCompleted = true;
            }
            finally {
                this.unlockExclusive();
            }
        }
        if (this.open && checkpointCompleted) {
            this.removeOldLogs(logFileRefCountsActive);
        }
        return true;
    }

    private void removeOldLogs(SortedSet<Integer> fileIDs) {
        Preconditions.checkState((boolean)this.open, (Object)"Log is closed");
        for (File fileToDelete : this.pendingDeletes) {
            LOGGER.info("Removing old file: " + fileToDelete);
            FileUtils.deleteQuietly((File)fileToDelete);
        }
        this.pendingDeletes.clear();
        int minFileID = fileIDs.first();
        LOGGER.debug("Files currently in use: " + fileIDs);
        for (File logDir : this.logDirs) {
            List<File> logs = LogUtils.getLogs(logDir);
            LogUtils.sort(logs);
            int size = logs.size() - 2;
            for (int index = 0; index < size; ++index) {
                File logFile = logs.get(index);
                int logFileID = LogUtils.getIDForFile(logFile);
                if (logFileID >= minFileID) continue;
                LogFile.RandomReader reader = this.idLogFileMap.remove(logFileID);
                if (reader != null) {
                    reader.close();
                }
                File metaDataFile = Serialization.getMetaDataFile(logFile);
                this.pendingDeletes.add(logFile);
                this.pendingDeletes.add(metaDataFile);
            }
        }
    }

    private void lock(File dir) throws IOException {
        FileLock lock = this.tryLock(dir);
        if (lock == null) {
            String msg = "Cannot lock " + dir + ". The directory is already locked. " + this.channelNameDescriptor;
            LOGGER.info(msg);
            throw new IOException(msg);
        }
        FileLock secondLock = this.tryLock(dir);
        if (secondLock != null) {
            LOGGER.warn("Directory " + dir + " does not support locking");
            secondLock.release();
            secondLock.channel().close();
        }
        this.locks.put(dir.getAbsolutePath(), lock);
    }

    private FileLock tryLock(File dir) throws IOException {
        File lockF = new File(dir, FILE_LOCK);
        lockF.deleteOnExit();
        RandomAccessFile file = new RandomAccessFile(lockF, "rws");
        FileLock res = null;
        try {
            res = file.getChannel().tryLock();
        }
        catch (OverlappingFileLockException oe) {
            file.close();
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Cannot create lock on " + lockF, (Throwable)e);
            file.close();
            throw e;
        }
        return res;
    }

    private void unlock(File dir) throws IOException {
        FileLock lock = this.locks.remove(dir.getAbsolutePath());
        if (lock == null) {
            return;
        }
        lock.release();
        lock.channel().close();
        lock = null;
    }

    static class BackgroundWorker
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(BackgroundWorker.class);
        private final Log log;

        public BackgroundWorker(Log log) {
            this.log = log;
        }

        @Override
        public void run() {
            try {
                if (this.log.open) {
                    this.log.writeCheckpoint();
                }
            }
            catch (IOException e) {
                LOG.error("Error doing checkpoint", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error("General error in checkpoint worker", e);
            }
        }
    }

    static class Builder {
        private long bCheckpointInterval;
        private long bMinimumRequiredSpace;
        private long bMaxFileSize;
        private int bQueueCapacity;
        private File bCheckpointDir;
        private File[] bLogDirs;
        private int bLogWriteTimeout = 10;
        private String bName;
        private int bCheckpointWriteTimeout = 600;
        private boolean useLogReplayV1;
        private boolean useFastReplay;
        private KeyProvider bEncryptionKeyProvider;
        private String bEncryptionKeyAlias;
        private String bEncryptionCipherProvider;
        private long bUsableSpaceRefreshInterval = 15000L;
        private boolean bUseDualCheckpoints = false;
        private File bBackupCheckpointDir = null;

        Builder() {
        }

        Builder setUsableSpaceRefreshInterval(long usableSpaceRefreshInterval) {
            this.bUsableSpaceRefreshInterval = usableSpaceRefreshInterval;
            return this;
        }

        Builder setCheckpointInterval(long interval) {
            this.bCheckpointInterval = interval;
            return this;
        }

        Builder setMaxFileSize(long maxSize) {
            this.bMaxFileSize = maxSize;
            return this;
        }

        Builder setQueueSize(int capacity) {
            this.bQueueCapacity = capacity;
            return this;
        }

        Builder setCheckpointDir(File cpDir) {
            this.bCheckpointDir = cpDir;
            return this;
        }

        Builder setLogDirs(File[] dirs) {
            this.bLogDirs = dirs;
            return this;
        }

        Builder setLogWriteTimeout(int timeout) {
            this.bLogWriteTimeout = timeout;
            return this;
        }

        Builder setChannelName(String name) {
            this.bName = name;
            return this;
        }

        Builder setMinimumRequiredSpace(long minimumRequiredSpace) {
            this.bMinimumRequiredSpace = minimumRequiredSpace;
            return this;
        }

        Builder setCheckpointWriteTimeout(int checkpointTimeout) {
            this.bCheckpointWriteTimeout = checkpointTimeout;
            return this;
        }

        Builder setUseLogReplayV1(boolean useLogReplayV1) {
            this.useLogReplayV1 = useLogReplayV1;
            return this;
        }

        Builder setUseFastReplay(boolean useFastReplay) {
            this.useFastReplay = useFastReplay;
            return this;
        }

        Builder setEncryptionKeyProvider(KeyProvider encryptionKeyProvider) {
            this.bEncryptionKeyProvider = encryptionKeyProvider;
            return this;
        }

        Builder setEncryptionKeyAlias(String encryptionKeyAlias) {
            this.bEncryptionKeyAlias = encryptionKeyAlias;
            return this;
        }

        Builder setEncryptionCipherProvider(String encryptionCipherProvider) {
            this.bEncryptionCipherProvider = encryptionCipherProvider;
            return this;
        }

        Builder setUseDualCheckpoints(boolean UseDualCheckpoints) {
            this.bUseDualCheckpoints = UseDualCheckpoints;
            return this;
        }

        Builder setBackupCheckpointDir(File backupCheckpointDir) {
            this.bBackupCheckpointDir = backupCheckpointDir;
            return this;
        }

        Log build() throws IOException {
            return new Log(this.bCheckpointInterval, this.bMaxFileSize, this.bQueueCapacity, this.bLogWriteTimeout, this.bCheckpointWriteTimeout, this.bUseDualCheckpoints, this.bCheckpointDir, this.bBackupCheckpointDir, this.bName, this.useLogReplayV1, this.useFastReplay, this.bMinimumRequiredSpace, this.bEncryptionKeyProvider, this.bEncryptionKeyAlias, this.bEncryptionCipherProvider, this.bUsableSpaceRefreshInterval, this.bLogDirs);
        }
    }
}

