/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;

public final class ToStringBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("toString");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToString(config, parent, child, context);
    }

    private static final class ToString
    extends AbstractCommand {
        private final String fieldName;

        public ToString(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, "field");
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            ListIterator<String> iter = record.get(this.fieldName).listIterator();
            while (iter.hasNext()) {
                String str = iter.next().toString();
                iter.set(str);
            }
            return super.doProcess(record);
        }
    }
}

