/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.FieldExpression;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;

abstract class LogCommand
extends AbstractCommand {
    private String format;
    private String[] args;

    public LogCommand(Config config, Command parent, Command child, MorphlineContext context) {
        super(config, parent, child, context);
        this.format = this.getConfigs().getString(config, "format");
        List<String> argList = this.getConfigs().getStringList(config, "args", Collections.EMPTY_LIST);
        this.args = argList.toArray(new String[argList.size()]);
        this.validateArguments();
    }

    @Override
    protected boolean doProcess(Record record) {
        Object[] resolvedArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            resolvedArgs[i] = new FieldExpression(this.args[i], this.getConfig()).evaluate(record);
        }
        this.log(this.format, resolvedArgs);
        return super.doProcess(record);
    }

    protected abstract void log(String var1, Object[] var2);
}

