/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.FieldExpression;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ContainsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("contains");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Contains(config, parent, child, context);
    }

    private static final class Contains
    extends AbstractCommand {
        private final Set<Map.Entry<String, Object>> entrySet;

        public Contains(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.entrySet = config.root().unwrapped().entrySet();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Map.Entry<String, Object> entry : this.entrySet) {
                String fieldName = entry.getKey();
                List values = record.get(fieldName);
                Object entryValue = entry.getValue();
                Collection results = entryValue instanceof Collection ? (Collection)entryValue : new FieldExpression(entryValue.toString(), this.getConfig()).evaluate(record);
                boolean found = false;
                for (Object result : results) {
                    if (!values.contains(result)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return super.doProcess(record);
        }
    }
}

