/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;

public final class AddLocalHostBuilder
implements CommandBuilder {
    public static final String FIELD_NAME = "field";
    public static final String PRESERVE_EXISTING_NAME = "preserveExisting";
    public static final String USE_IP = "useIP";

    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("addLocalHost");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new AddLocalHost(config, parent, child, context);
    }

    private static final class AddLocalHost
    extends AbstractCommand {
        private final String fieldName;
        private final boolean preserveExisting;
        private final String host;

        public AddLocalHost(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, AddLocalHostBuilder.FIELD_NAME, "host");
            this.preserveExisting = this.getConfigs().getBoolean(config, AddLocalHostBuilder.PRESERVE_EXISTING_NAME, true);
            boolean useIP = this.getConfigs().getBoolean(config, AddLocalHostBuilder.USE_IP, true);
            this.validateArguments();
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                this.LOG.warn("Cannot get address of local host", (Throwable)e);
            }
            this.host = addr == null ? null : (useIP ? addr.getHostAddress() : addr.getCanonicalHostName());
        }

        @Override
        protected boolean doProcess(Record record) {
            if (!this.preserveExisting || !record.getFields().containsKey((Object)this.fieldName)) {
                record.removeAll(this.fieldName);
                if (this.host != null) {
                    record.put(this.fieldName, this.host);
                }
            }
            return super.doProcess(record);
        }
    }
}

