/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.FieldExpression;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

abstract class AbstractAddValuesCommand
extends AbstractCommand {
    private final Set<Map.Entry<String, Object>> entrySet;

    public AbstractAddValuesCommand(Config config, Command parent, Command child, MorphlineContext context) {
        super(config, parent, child, context);
        this.entrySet = config.root().unwrapped().entrySet();
    }

    @Override
    protected boolean doProcess(Record record) {
        for (Map.Entry<String, Object> entry : this.entrySet) {
            String fieldName = entry.getKey();
            this.prepare(record, fieldName);
            Object entryValue = entry.getValue();
            Collection results = entryValue instanceof Collection ? (Collection)entryValue : new FieldExpression(entryValue.toString(), this.getConfig()).evaluate(record);
            this.putAll(record, fieldName, results);
        }
        return super.doProcess(record);
    }

    protected void prepare(Record record, String key) {
    }

    protected void putAll(Record record, String key, Collection values) {
        record.getFields().putAll((Object)key, (Iterable)values);
    }

    protected void put(Record record, String key, Object value) {
        record.getFields().put((Object)key, value);
    }
}

