/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.google.common.io.CharStreams;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;

public final class ReadClobBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readClob");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadClob(config, parent, child, context);
    }

    private static final class ReadClob
    extends AbstractParser {
        private final Charset charset;

        public ReadClob(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            this.incrementNumRecords();
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            String clob = CharStreams.toString((Readable)reader);
            Record outputRecord = inputRecord.copy();
            ReadClob.removeAttachments(outputRecord);
            outputRecord.replaceValues("message", clob);
            return this.getChild().process(outputRecord);
        }
    }
}

