/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.scriptengine.java;

import com.cloudera.cdk.morphline.scriptengine.java.JavaCompiler;
import com.cloudera.cdk.morphline.scriptengine.java.MemoryClassLoader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class FastJavaScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private JavaCompiler compiler = new JavaCompiler();
    private static final String SYSPROP_PREFIX = "com.sun.script.java.";
    private static final String SOURCEPATH = "sourcepath";
    private static final String CLASSPATH = "classpath";
    private static final String MAINCLASS = "mainClass";
    private static final String PARENTLOADER = "parentLoader";

    public CompiledScript compile(String script, String methodName, Class[] parameterTypes) throws ScriptException {
        Class clazz = this.parse(script, this.context);
        return new JavaCompiledScript(clazz, methodName, parameterTypes);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private Class parse(String str, ScriptContext ctx) throws ScriptException {
        Iterable<Class> classes;
        String fileName = FastJavaScriptEngine.getFileName(ctx);
        String sourcePath = FastJavaScriptEngine.getSourcePath(ctx);
        String classPath = FastJavaScriptEngine.getClassPath(ctx);
        Map<String, byte[]> classBytes = this.compiler.compile(fileName, str, ctx.getErrorWriter(), sourcePath, classPath);
        if (classBytes == null) {
            throw new ScriptException("compilation failed");
        }
        MemoryClassLoader loader = new MemoryClassLoader(classBytes, classPath, FastJavaScriptEngine.getParentLoader(ctx));
        String mainClassName = FastJavaScriptEngine.getMainClassName(ctx);
        if (mainClassName != null) {
            try {
                Class clazz = loader.load(mainClassName);
                Method mainMethod = FastJavaScriptEngine.findMainMethod(clazz);
                if (mainMethod == null) {
                    throw new ScriptException("no main method in " + mainClassName);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ScriptException(cnfe);
            }
        }
        try {
            classes = loader.loadAll();
        }
        catch (ClassNotFoundException exp) {
            throw new ScriptException(exp);
        }
        Class c = FastJavaScriptEngine.findMainClass(classes);
        if (c != null) {
            return c;
        }
        Iterator<Class> itr = classes.iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        return null;
    }

    private static Class findMainClass(Iterable<Class> classes) {
        for (Class clazz : classes) {
            Method mainMethod;
            int modifiers = clazz.getModifiers();
            if (!Modifier.isPublic(modifiers) || (mainMethod = FastJavaScriptEngine.findMainMethod(clazz)) == null) continue;
            return clazz;
        }
        for (Class clazz : classes) {
            Method mainMethod = FastJavaScriptEngine.findMainMethod(clazz);
            if (mainMethod == null) continue;
            return clazz;
        }
        return null;
    }

    private static Method findMainMethod(Class clazz) {
        try {
            Method mainMethod = clazz.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return mainMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static String getFileName(ScriptContext ctx) {
        int scope = ctx.getAttributesScope("javax.script.filename");
        if (scope != -1) {
            return ctx.getAttribute("javax.script.filename", scope).toString();
        }
        return "$unnamed.java";
    }

    private static String getSourcePath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(SOURCEPATH);
        if (scope != -1) {
            return ctx.getAttribute(SOURCEPATH).toString();
        }
        return System.getProperty("com.sun.script.java.sourcepath");
    }

    private static String getClassPath(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(CLASSPATH);
        if (scope != -1) {
            return ctx.getAttribute(CLASSPATH).toString();
        }
        String res = System.getProperty("com.sun.script.java.classpath");
        if (res == null) {
            res = System.getProperty("java.class.path");
        }
        return res;
    }

    private static String getMainClassName(ScriptContext ctx) {
        int scope = ctx.getAttributesScope(MAINCLASS);
        if (scope != -1) {
            return ctx.getAttribute(MAINCLASS).toString();
        }
        return System.getProperty("com.sun.script.java.mainClass");
    }

    private static ClassLoader getParentLoader(ScriptContext ctx) {
        Object loader;
        int scope = ctx.getAttributesScope(PARENTLOADER);
        if (scope != -1 && (loader = ctx.getAttribute(PARENTLOADER)) instanceof ClassLoader) {
            return (ClassLoader)loader;
        }
        return null;
    }

    public static final class JavaCompiledScript
    extends CompiledScript {
        private final Method targetMethod;

        JavaCompiledScript(Class clazz, String methodName, Class[] parameterTypes) throws ScriptException {
            try {
                this.targetMethod = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptException(e);
            }
            int modifiers = this.targetMethod.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
                throw new ScriptException("Cannot find public static method: " + methodName);
            }
        }

        public Object eval(Object ... params) throws ScriptException {
            try {
                return this.targetMethod.invoke(null, params);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }

        @Override
        public ScriptEngine getEngine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            throw new UnsupportedOperationException();
        }
    }
}

