/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.Record;
import java.util.List;

public final class Notifications {
    public static final String LIFE_CYLCLE = "lifecycle";

    public static List getLifecycleEvents(Record notification) {
        return notification.get(LIFE_CYLCLE);
    }

    public static void notifyBeginTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.BEGIN_TRANSACTION);
    }

    public static void notifyCommitTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.COMMIT_TRANSACTION);
    }

    public static void notifyRollbackTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.ROLLBACK_TRANSACTION);
    }

    public static void notifyShutdown(Command command) {
        Notifications.notify(command, LifecycleEvent.SHUTDOWN);
    }

    public static void notifyStartSession(Command command) {
        Notifications.notify(command, LifecycleEvent.START_SESSION);
    }

    private static void notify(Command command, LifecycleEvent event) {
        Record notification = new Record();
        notification.put(LIFE_CYLCLE, (Object)event);
        command.notify(notification);
    }

    public static boolean containsLifecycleEvent(Record notification, LifecycleEvent event) {
        return Notifications.getLifecycleEvents(notification).contains((Object)event);
    }

    public static enum LifecycleEvent {
        BEGIN_TRANSACTION,
        COMMIT_TRANSACTION,
        ROLLBACK_TRANSACTION,
        SHUTDOWN,
        START_SESSION;

    }
}

