/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.api;

import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.ExceptionHandler;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.shaded.com.google.common.reflect.ClassPath;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineContext {
    private ExceptionHandler exceptionHandler;
    private MetricRegistry metricRegistry;
    private Map<String, Class<CommandBuilder>> commandBuilders = Collections.EMPTY_MAP;
    private static final Logger LOG = LoggerFactory.getLogger(MorphlineContext.class);

    protected MorphlineContext() {
    }

    public ExceptionHandler getExceptionHandler() {
        assert (this.exceptionHandler != null);
        return this.exceptionHandler;
    }

    public MetricRegistry getMetricRegistry() {
        assert (this.metricRegistry != null);
        return this.metricRegistry;
    }

    public Class<CommandBuilder> getCommandBuilder(String builderName) {
        return this.commandBuilders.get(builderName);
    }

    public void importCommandBuilders(Collection<String> importSpecs) {
        if (this.commandBuilders == Collections.EMPTY_MAP) {
            this.commandBuilders = new HashMap<String, Class<CommandBuilder>>();
            Collection<Class<CommandBuilder>> builderClasses = this.getTopLevelClasses(importSpecs, CommandBuilder.class);
            for (Class<CommandBuilder> builderClass : builderClasses) {
                try {
                    CommandBuilder builder = builderClass.newInstance();
                    for (String builderName : builder.getNames()) {
                        LOG.info("Importing command: {} from class: {}", (Object)builderName, (Object)builderClass.getName());
                        if (builderName.contains(".")) {
                            LOG.warn("Command name should not contain a period character: " + builderName);
                        }
                        this.commandBuilders.put(builderName, builderClass);
                    }
                }
                catch (Exception e) {
                    throw new MorphlineRuntimeException(e);
                }
            }
        }
    }

    <T> Collection<Class<T>> getTopLevelClasses(Iterable<String> importSpecs, Class<T> iface) {
        LinkedHashMap<String, Class<T>> classes = new LinkedHashMap<String, Class<T>>();
        for (ClassLoader loader : this.getClassLoaders()) {
            ClassPath classPath;
            try {
                classPath = ClassPath.from(loader);
            }
            catch (IOException e) {
                continue;
            }
            for (String importSpec : importSpecs) {
                String packageName;
                ImmutableSet<ClassPath.ClassInfo> classInfos = null;
                if (importSpec.endsWith(".**")) {
                    packageName = importSpec.substring(0, importSpec.length() - ".**".length());
                    classInfos = classPath.getTopLevelClassesRecursive(packageName);
                } else if (importSpec.endsWith(".*")) {
                    packageName = importSpec.substring(0, importSpec.length() - ".*".length());
                    classInfos = classPath.getTopLevelClasses(packageName);
                } else {
                    Class<?> clazz;
                    try {
                        clazz = loader.loadClass(importSpec);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    this.addClass(clazz, classes, iface);
                    continue;
                }
                for (ClassPath.ClassInfo info : classInfos) {
                    Class<?> clazz;
                    try {
                        clazz = info.load();
                    }
                    catch (NoClassDefFoundError e) {
                        continue;
                    }
                    catch (ExceptionInInitializerError e) {
                        continue;
                    }
                    catch (UnsatisfiedLinkError e) {
                        continue;
                    }
                    this.addClass(clazz, classes, iface);
                }
            }
        }
        return ((HashMap)classes).values();
    }

    private <T> void addClass(Class clazz, HashMap<String, Class<T>> classes, Class<T> iface) {
        if (!classes.containsKey(clazz.getName()) && iface.isAssignableFrom(clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            for (Constructor<?> ctor : clazz.getConstructors()) {
                if (ctor.getParameterTypes().length != 0) continue;
                classes.put(clazz.getName(), clazz);
            }
        }
    }

    private ClassLoader[] getClassLoaders() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader myLoader = this.getClass().getClassLoader();
        if (contextLoader == null) {
            return new ClassLoader[]{myLoader};
        }
        if (contextLoader == myLoader || myLoader == null) {
            return new ClassLoader[]{contextLoader};
        }
        return new ClassLoader[]{contextLoader, myLoader};
    }

    private static final class DefaultExceptionHandler
    implements ExceptionHandler {
        private DefaultExceptionHandler() {
        }

        @Override
        public void handleException(Throwable t, Record record) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new MorphlineRuntimeException(t);
        }
    }

    public static class Builder {
        protected MorphlineContext context = this.create();
        private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
        private MetricRegistry metricRegistry = new MetricRegistry();

        public Builder setExceptionHandler(ExceptionHandler exceptionHandler) {
            Preconditions.checkNotNull((Object)exceptionHandler);
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public Builder setMetricRegistry(MetricRegistry metricRegistry) {
            Preconditions.checkNotNull((Object)metricRegistry);
            this.metricRegistry = metricRegistry;
            return this;
        }

        public MorphlineContext build() {
            this.context.exceptionHandler = this.exceptionHandler;
            this.context.metricRegistry = this.metricRegistry;
            return this.context;
        }

        protected MorphlineContext create() {
            return new MorphlineContext();
        }
    }
}

