/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZooKeeperDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDownloader.class);

    ZooKeeperDownloader() {
    }

    public SolrZkClient getZkClient(String zkHost) {
        SolrZkClient zkClient;
        if (zkHost == null) {
            throw new IllegalArgumentException("zkHost must not be null");
        }
        try {
            zkClient = new SolrZkClient(zkHost, 30000);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot connect to ZooKeeper: " + zkHost, e);
        }
        return zkClient;
    }

    public String readConfigName(SolrZkClient zkClient, String collection) throws KeeperException, InterruptedException {
        byte[] data;
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        String configName = null;
        String path = "/collections/" + collection;
        if (LOG.isInfoEnabled()) {
            LOG.info("Load collection config from:" + path);
        }
        if ((data = zkClient.getData(path, null, null, true)) != null) {
            ZkNodeProps props = ZkNodeProps.load((byte[])data);
            configName = props.getStr("configName");
        }
        if (configName != null && !zkClient.exists("/configs/" + configName, true).booleanValue()) {
            LOG.error("Specified config does not exist in ZooKeeper:" + configName);
            throw new IllegalArgumentException("Specified config does not exist in ZooKeeper:" + configName);
        }
        return configName;
    }

    public File downloadConfigDir(SolrZkClient zkClient, String configName) throws IOException, InterruptedException, KeeperException {
        File dir = Files.createTempDir();
        dir.deleteOnExit();
        ZkController.downloadConfigDir((SolrZkClient)zkClient, (String)configName, (File)dir);
        File confDir = new File(dir, "conf");
        if (!confDir.isDirectory()) {
            confDir = new File(Files.createTempDir().getAbsolutePath(), "conf");
            confDir.getParentFile().deleteOnExit();
            Files.move((File)dir, (File)confDir);
            dir = confDir.getParentFile();
        }
        return dir;
    }
}

