/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Notifications;
import com.cloudera.cdk.morphline.solr.DocumentLoader;
import com.cloudera.cdk.morphline.solr.SolrLocator;
import com.codahale.metrics.Timer;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;

public final class LoadSolrBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("loadSolr");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new LoadSolr(config, parent, child, context);
    }

    private static final class LoadSolr
    extends AbstractCommand {
        private final DocumentLoader loader;
        private final Timer elapsedTime;

        public LoadSolr(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.loader = locator.getLoader();
            this.validateArguments();
            this.elapsedTime = this.getTimer(new String[]{"elapsedTime"});
        }

        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents((Record)notification)) {
                if (event == Notifications.LifecycleEvent.BEGIN_TRANSACTION) {
                    try {
                        this.loader.beginTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.COMMIT_TRANSACTION) {
                    try {
                        this.loader.commitTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.ROLLBACK_TRANSACTION) {
                    try {
                        this.loader.rollbackTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                try {
                    this.loader.shutdown();
                }
                catch (SolrServerException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
            }
            super.doNotify(notification);
        }

        protected boolean doProcess(Record record) {
            Timer.Context timerContext = this.elapsedTime.time();
            SolrInputDocument doc = this.convert(record);
            try {
                this.loader.load(doc);
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (SolrServerException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            finally {
                timerContext.stop();
            }
            return super.doProcess(record);
        }

        private SolrInputDocument convert(Record record) {
            SolrInputDocument doc = new SolrInputDocument();
            for (Map.Entry entry : record.getFields().entries()) {
                doc.addField((String)entry.getKey(), entry.getValue());
            }
            return doc;
        }
    }
}

