/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ParseUtils;
import com.spatial4j.core.shape.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.AbstractSubTypeFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.LatLonValueSource;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialDistanceQuery;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;

public class LatLonType
extends AbstractSubTypeFieldType
implements SpatialQueryable {
    protected static final int LAT = 0;
    protected static final int LON = 1;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.createSuffixCache(3);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        String externalVal = value.toString();
        ArrayList<IndexableField> f = new ArrayList<IndexableField>(3);
        if (field.indexed()) {
            double[] latLon;
            int i = 0;
            try {
                latLon = ParseUtils.parseLatitudeLongitude(null, (String)externalVal);
            }
            catch (InvalidShapeException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            SchemaField lat = this.subField(field, i);
            f.add(lat.createField(String.valueOf(latLon[0]), lat.indexed() && !lat.omitNorms() ? boost : 1.0f));
            SchemaField lon = this.subField(field, ++i);
            f.add(lon.createField(String.valueOf(latLon[1]), lon.indexed() && !lon.omitNorms() ? boost : 1.0f));
        }
        if (field.stored()) {
            FieldType customType = new FieldType();
            customType.setStored(true);
            f.add(this.createField(field.getName(), externalVal, customType, 1.0f));
        }
        return f;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String[] p2;
        String[] p1;
        int dimension = 2;
        try {
            p1 = ParseUtils.parsePoint(null, (String)part1, (int)dimension);
            p2 = ParseUtils.parsePoint(null, (String)part2, (int)dimension);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery result = new BooleanQuery(true);
        for (int i = 0; i < dimension; ++i) {
            SchemaField subSF = this.subField(field, i);
            result.add(subSF.getType().getRangeQuery(parser, subSF, p1[i], p2[i], minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        }
        return result;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        int dimension = 2;
        String[] p1 = new String[]{};
        try {
            p1 = ParseUtils.parsePoint(null, (String)externalVal, (int)dimension);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (int i = 0; i < dimension; ++i) {
            SchemaField sf = this.subField(field, i);
            Query tq = sf.getType().getFieldQuery(parser, sf, p1[i]);
            bq.add(tq, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double lon2Max;
        double lon2Min;
        double lonMax;
        double lonMin;
        double[] point = null;
        try {
            point = ParseUtils.parseLatitudeLongitude((String)options.pointStr);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        double latCenter = point[0];
        double lonCenter = point[1];
        double distDeg = DistanceUtils.dist2Degrees((double)options.distance, (double)options.radius);
        Rectangle bbox = DistanceUtils.calcBoxByDistFromPtDEG((double)latCenter, (double)lonCenter, (double)distDeg, (SpatialContext)SpatialContext.GEO, null);
        double latMin = bbox.getMinY();
        double latMax = bbox.getMaxY();
        if (bbox.getCrossesDateLine()) {
            lonMin = -180.0;
            lonMax = bbox.getMaxX();
            lon2Min = bbox.getMinX();
            lon2Max = 180.0;
        } else {
            lonMin = bbox.getMinX();
            lonMax = bbox.getMaxX();
            lon2Min = -180.0;
            lon2Max = 180.0;
        }
        SchemaField latField = this.subField(options.field, 0);
        SchemaField lonField = this.subField(options.field, 1);
        SpatialDistanceQuery spatial = new SpatialDistanceQuery();
        if (options.bbox) {
            BooleanQuery result = new BooleanQuery();
            Query latRange = latField.getType().getRangeQuery(parser, latField, String.valueOf(latMin), String.valueOf(latMax), true, true);
            result.add(latRange, BooleanClause.Occur.MUST);
            if (lonMin != -180.0 || lonMax != 180.0) {
                Query lonRange = lonField.getType().getRangeQuery(parser, lonField, String.valueOf(lonMin), String.valueOf(lonMax), true, true);
                if (lon2Min != -180.0 || lon2Max != 180.0) {
                    BooleanQuery bothLons = new BooleanQuery();
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = lonField.getType().getRangeQuery(parser, lonField, String.valueOf(lon2Min), String.valueOf(lon2Max), true, true);
                    bothLons.add(lonRange, BooleanClause.Occur.SHOULD);
                    lonRange = bothLons;
                }
                result.add(lonRange, BooleanClause.Occur.MUST);
            }
            spatial.bboxQuery = result;
        }
        spatial.origField = options.field.getName();
        spatial.latSource = latField.getType().getValueSource(latField, parser);
        spatial.lonSource = lonField.getType().getValueSource(lonField, parser);
        spatial.latMin = latMin;
        spatial.latMax = latMax;
        spatial.lonMin = lonMin;
        spatial.lonMax = lonMax;
        spatial.lon2Min = lon2Min;
        spatial.lon2Max = lon2Max;
        spatial.lon2 = lon2Min != -180.0 || lon2Max != 180.0;
        spatial.latCenter = latCenter;
        spatial.lonCenter = lonCenter;
        spatial.dist = options.distance;
        spatial.planetRadius = options.radius;
        spatial.calcDist = !options.bbox;
        return spatial;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        ArrayList<ValueSource> vs = new ArrayList<ValueSource>(2);
        for (int i = 0; i < 2; ++i) {
            SchemaField sub = this.subField(field, i);
            vs.add(sub.getType().getValueSource(sub, parser));
        }
        return new LatLonValueSource(field, vs);
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on LatLonType " + field.getName());
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        throw new UnsupportedOperationException("LatLonType uses multiple fields.  field=" + field.getName());
    }
}

