/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.DateFieldSource;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.DateMathParser;

public class DateField
extends PrimitiveFieldType {
    public static TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected static final TimeZone MATH_TZ = DateMathParser.DEFAULT_MATH_TZ;
    protected static final Locale MATH_LOCALE = DateMathParser.DEFAULT_MATH_LOCALE;
    protected static final TimeZone CANONICAL_TZ = UTC;
    protected static final Locale CANONICAL_LOCALE = Locale.ROOT;
    protected static String NOW = "NOW";
    protected static char Z = (char)90;
    private static char[] Z_ARRAY = new char[]{Z};
    private static final ThreadLocalDateFormat fmtThreadLocal = new ThreadLocalDateFormat(new ISO8601CanonicalDateFormat());

    @Override
    public String toInternal(String val) {
        return this.toInternal(this.parseMath(null, val));
    }

    public Date parseMath(Date now, String val) {
        String math = null;
        DateMathParser p = new DateMathParser();
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith(NOW)) {
            math = val.substring(NOW.length());
        } else {
            int zz = val.indexOf(Z);
            if (0 < zz) {
                math = val.substring(zz + 1);
                try {
                    p.setNow(DateField.parseDate(val.substring(0, zz + 1)));
                }
                catch (ParseException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date in Date Math String:'" + val + '\'', (Throwable)e);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date String:'" + val + '\'');
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date Math String:'" + val + '\'', (Throwable)e);
        }
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        if (value instanceof Date) {
            value = this.toInternal((Date)value) + Z;
        }
        return super.createField(field, value, boost);
    }

    public String toInternal(Date val) {
        return this.formatDate(val);
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return indexedForm + Z;
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRef charsRef) {
        UnicodeUtil.UTF8toUTF16((BytesRef)input, (CharsRef)charsRef);
        charsRef.append(Z_ARRAY, 0, 1);
        return charsRef;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.indexedToReadable(f.stringValue());
    }

    public Date toObject(String indexedForm) throws ParseException {
        return DateField.parseDate(this.indexedToReadable(indexedForm));
    }

    @Override
    public Date toObject(IndexableField f) {
        try {
            return DateField.parseDate(this.toExternal(f));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeDate(name, this.toExternal(f));
    }

    @Deprecated
    protected DateFormat getThreadLocalDateFormat() {
        return (DateFormat)fmtThreadLocal.get();
    }

    protected String formatDate(Date d) {
        return ((DateFormat)fmtThreadLocal.get()).format(d);
    }

    public static String formatExternal(Date d) {
        return ((DateFormat)fmtThreadLocal.get()).format(d) + 'Z';
    }

    public String toExternal(Date d) {
        return DateField.formatExternal(d);
    }

    public static Date parseDate(String s) throws ParseException {
        return ((DateFormat)fmtThreadLocal.get()).parse(s);
    }

    public Date parseDateLenient(String s, SolrQueryRequest req) throws ParseException {
        try {
            return ((DateFormat)fmtThreadLocal.get()).parse(s);
        }
        catch (Exception e) {
            return DateUtil.parseDate((String)s);
        }
    }

    public Date parseMathLenient(Date now, String val, SolrQueryRequest req) {
        String math = null;
        DateMathParser p = new DateMathParser();
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith(NOW)) {
            math = val.substring(NOW.length());
        } else {
            int zz = val.indexOf(Z);
            if (0 < zz) {
                math = val.substring(zz + 1);
                try {
                    p.setNow(this.parseDateLenient(val.substring(0, zz + 1), req));
                }
                catch (ParseException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date in Date Math String:'" + val + '\'', (Throwable)e);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date String:'" + val + '\'');
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date Math String:'" + val + '\'', (Throwable)e);
        }
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new DateFieldSource(field.getName(), field);
    }

    public Query getRangeQuery(QParser parser, SchemaField sf, Date part1, Date part2, boolean minInclusive, boolean maxInclusive) {
        return TermRangeQuery.newStringRange((String)sf.getName(), (String)(part1 == null ? null : this.toInternal(part1)), (String)(part2 == null ? null : this.toInternal(part2)), (boolean)minInclusive, (boolean)maxInclusive);
    }

    private static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        DateFormat proto;

        public ThreadLocalDateFormat(DateFormat d) {
            this.proto = d;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.proto.clone();
        }
    }

    private static class ISO8601CanonicalDateFormat
    extends SimpleDateFormat {
        protected NumberFormat millisParser = NumberFormat.getIntegerInstance(CANONICAL_LOCALE);
        protected NumberFormat millisFormat = new DecimalFormat(".###", new DecimalFormatSymbols(CANONICAL_LOCALE));

        public ISO8601CanonicalDateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ss", CANONICAL_LOCALE);
            this.setTimeZone(CANONICAL_TZ);
        }

        @Override
        public Date parse(String i, ParsePosition p) {
            Date d = super.parse(i, p);
            int milliIndex = p.getIndex();
            if (null != d && -1 == p.getErrorIndex() && milliIndex + 1 < i.length() && '.' == i.charAt(milliIndex)) {
                p.setIndex(++milliIndex);
                Number millis = this.millisParser.parse(i, p);
                if (-1 == p.getErrorIndex()) {
                    int endIndex = p.getIndex();
                    d = new Date(d.getTime() + (long)(millis.doubleValue() * Math.pow(10.0, 3 - endIndex + milliIndex)));
                }
            }
            return d;
        }

        @Override
        public StringBuffer format(Date d, StringBuffer toAppendTo, FieldPosition pos) {
            super.format(d, toAppendTo, pos);
            long millis = d.getTime() % 1000L;
            if (0L == millis) {
                return toAppendTo;
            }
            if (millis < 0L) {
                millis += 1000L;
            }
            int posBegin = toAppendTo.length();
            toAppendTo.append(this.millisFormat.format((double)millis / 1000.0));
            if (8 == pos.getField()) {
                pos.setBeginIndex(posBegin);
                pos.setEndIndex(toAppendTo.length());
            }
            return toAppendTo;
        }

        @Override
        public DateFormat clone() {
            ISO8601CanonicalDateFormat c = (ISO8601CanonicalDateFormat)super.clone();
            c.millisParser = NumberFormat.getIntegerInstance(CANONICAL_LOCALE);
            c.millisFormat = new DecimalFormat(".###", new DecimalFormatSymbols(CANONICAL_LOCALE));
            return c;
        }
    }
}

