/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrResourceLoader;

public class CoreDescriptor {
    public static final String CORE_NAME = "name";
    public static final String CORE_CONFIG = "config";
    public static final String CORE_INSTDIR = "instanceDir";
    public static final String CORE_DATADIR = "dataDir";
    public static final String CORE_ULOGDIR = "ulogDir";
    public static final String CORE_SCHEMA = "schema";
    public static final String CORE_SHARD = "shard";
    public static final String CORE_COLLECTION = "collection";
    public static final String CORE_ROLES = "roles";
    public static final String CORE_PROPERTIES = "properties";
    public static final String CORE_LOADONSTARTUP = "loadOnStartup";
    public static final String CORE_TRANSIENT = "transient";
    public static final String CORE_NODE_NAME = "coreNodeName";
    static final String[] standardPropNames = new String[]{"name", "config", "instanceDir", "dataDir", "ulogDir", "schema", "shard", "collection", "roles", "properties", "loadOnStartup", "transient"};
    private Properties coreProperties = new Properties();
    private boolean loadedImplicit = false;
    private final CoreContainer coreContainer;
    private CloudDescriptor cloudDesc;

    private CoreDescriptor(CoreContainer cont) {
        this.coreContainer = cont;
        this.coreProperties.put(CORE_LOADONSTARTUP, "true");
        this.coreProperties.put(CORE_TRANSIENT, "false");
    }

    public CoreDescriptor(CoreContainer container, String name, String instanceDir) {
        this(container);
        this.doInit(name, instanceDir);
    }

    public CoreDescriptor(CoreDescriptor descr) {
        this(descr.coreContainer);
        this.coreProperties.put(CORE_INSTDIR, descr.getInstanceDir());
        this.coreProperties.put(CORE_CONFIG, descr.getConfigName());
        this.coreProperties.put(CORE_SCHEMA, descr.getSchemaName());
        this.coreProperties.put(CORE_NAME, descr.getName());
        this.coreProperties.put(CORE_DATADIR, descr.getDataDir());
    }

    public CoreDescriptor(CoreContainer container, Properties propsIn) {
        this(container);
        this.doInit(propsIn.getProperty(CORE_NAME), propsIn.getProperty(CORE_INSTDIR));
        this.coreProperties.putAll((Map<?, ?>)propsIn);
    }

    private void doInit(String name, String instanceDir) {
        if (name == null) {
            throw new RuntimeException("Core needs a name");
        }
        this.coreProperties.put(CORE_NAME, name);
        if (this.coreContainer != null && this.coreContainer.getZkController() != null) {
            this.cloudDesc = new CloudDescriptor();
            this.cloudDesc.setCollectionName(name);
        }
        if (instanceDir == null) {
            throw new NullPointerException("Missing required 'instanceDir'");
        }
        instanceDir = SolrResourceLoader.normalizeDir(instanceDir);
        this.coreProperties.put(CORE_INSTDIR, instanceDir);
        this.coreProperties.put(CORE_CONFIG, this.getDefaultConfigName());
        this.coreProperties.put(CORE_SCHEMA, this.getDefaultSchemaName());
    }

    public Properties initImplicitProperties() {
        Properties implicitProperties = new Properties();
        if (this.coreContainer != null && this.coreContainer.getContainerProperties() != null) {
            implicitProperties.putAll((Map<?, ?>)this.coreContainer.getContainerProperties());
        }
        implicitProperties.setProperty("solr.core.name", this.getName());
        implicitProperties.setProperty("solr.core.instanceDir", this.getInstanceDir());
        implicitProperties.setProperty("solr.core.dataDir", this.getDataDir());
        implicitProperties.setProperty("solr.core.configName", this.getConfigName());
        implicitProperties.setProperty("solr.core.schemaName", this.getSchemaName());
        return implicitProperties;
    }

    public String getDefaultConfigName() {
        return "solrconfig.xml";
    }

    public String getDefaultSchemaName() {
        return "schema.xml";
    }

    public String getDefaultDataDir() {
        return "data" + File.separator;
    }

    public String getPropertiesName() {
        return this.coreProperties.getProperty(CORE_PROPERTIES);
    }

    public void setPropertiesName(String propertiesName) {
        this.coreProperties.put(CORE_PROPERTIES, propertiesName);
    }

    public String getDataDir() {
        String dataDir = this.coreProperties.getProperty(CORE_DATADIR);
        if (dataDir == null) {
            dataDir = this.getDefaultDataDir();
        }
        return dataDir;
    }

    public void setDataDir(String s) {
        if (StringUtils.isBlank((String)s)) {
            this.coreProperties.remove(s);
        } else {
            this.coreProperties.put(CORE_DATADIR, s);
        }
    }

    public boolean usingDefaultDataDir() {
        return this.coreProperties.getProperty(CORE_DATADIR) == null;
    }

    public String getRawInstanceDir() {
        return this.coreProperties.getProperty(CORE_INSTDIR);
    }

    public String getInstanceDir() {
        String coreRootDir;
        String instDir = this.coreProperties.getProperty(CORE_INSTDIR);
        if (instDir == null) {
            return null;
        }
        if (new File(instDir).isAbsolute()) {
            return SolrResourceLoader.normalizeDir(SolrResourceLoader.normalizeDir(instDir));
        }
        if (this.coreContainer == null) {
            return null;
        }
        if (this.coreContainer.cfg != null && (coreRootDir = this.coreContainer.cfg.get(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, null)) != null) {
            return SolrResourceLoader.normalizeDir(coreRootDir + SolrResourceLoader.normalizeDir(instDir));
        }
        return SolrResourceLoader.normalizeDir(this.coreContainer.getSolrHome() + SolrResourceLoader.normalizeDir(instDir));
    }

    public void setConfigName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.coreProperties.put(CORE_CONFIG, name);
    }

    public String getConfigName() {
        return this.coreProperties.getProperty(CORE_CONFIG);
    }

    public void setSchemaName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.coreProperties.put(CORE_SCHEMA, name);
    }

    public String getSchemaName() {
        return this.coreProperties.getProperty(CORE_SCHEMA);
    }

    public String getName() {
        return this.coreProperties.getProperty(CORE_NAME);
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    Properties getCoreProperties() {
        return this.coreProperties;
    }

    public void setCoreProperties(Properties coreProperties) {
        if (!this.loadedImplicit) {
            this.loadedImplicit = true;
            Properties p = this.initImplicitProperties();
            this.coreProperties.putAll((Map<?, ?>)p);
            if (coreProperties != null) {
                this.coreProperties.putAll((Map<?, ?>)coreProperties);
            }
        }
    }

    public CloudDescriptor getCloudDescriptor() {
        return this.cloudDesc;
    }

    public void setCloudDescriptor(CloudDescriptor cloudDesc) {
        this.cloudDesc = cloudDesc;
    }

    public boolean isLoadOnStartup() {
        String tmp = this.coreProperties.getProperty(CORE_LOADONSTARTUP, "false");
        return Boolean.parseBoolean(tmp);
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.coreProperties.put(CORE_LOADONSTARTUP, Boolean.toString(loadOnStartup));
    }

    public boolean isTransient() {
        String tmp = this.coreProperties.getProperty(CORE_TRANSIENT, "false");
        return Boolean.parseBoolean(tmp);
    }

    public void setTransient(boolean isTransient) {
        this.coreProperties.put(CORE_TRANSIENT, Boolean.toString(isTransient));
    }

    public String getUlogDir() {
        return this.coreProperties.getProperty(CORE_ULOGDIR);
    }

    public void setUlogDir(String ulogDir) {
        this.coreProperties.put(CORE_ULOGDIR, ulogDir);
    }

    public String getProperty(String prop, String defVal) {
        return this.coreProperties.getProperty(prop, defVal);
    }

    public String getProperty(String prop) {
        return this.coreProperties.getProperty(prop);
    }

    public void putProperty(String prop, String val) {
        this.coreProperties.put(prop, val);
    }

    public String getAbsoluteDataDir() {
        String dataDir = this.getDataDir();
        if (dataDir == null) {
            return null;
        }
        if (new File(dataDir).isAbsolute()) {
            return SolrResourceLoader.normalizeDir(SolrResourceLoader.normalizeDir(dataDir));
        }
        if (this.coreContainer == null) {
            return null;
        }
        return SolrResourceLoader.normalizeDir(this.coreContainer.getSolrHome() + SolrResourceLoader.normalizeDir(dataDir));
    }
}

