/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreMaps;
import org.apache.solr.core.SolrCore;

class CloserThread
extends Thread {
    CoreContainer container;
    CoreMaps coreMaps;
    ConfigSolr cfg;

    CloserThread(CoreContainer container, CoreMaps coreMaps, ConfigSolr cfg) {
        this.container = container;
        this.coreMaps = coreMaps;
        this.cfg = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.container.isShutDown()) {
            Object object = this.coreMaps.getLocker();
            synchronized (object) {
                try {
                    this.coreMaps.getLocker().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SolrCore removeMe = this.coreMaps.getCoreToClose();
            while (removeMe != null && !this.container.isShutDown()) {
                try {
                    this.coreMaps.addPersistOneCore(this.cfg, this.container.loader, removeMe.getCoreDescriptor(), this.container.getCoreToOrigName(removeMe));
                    removeMe.close();
                }
                finally {
                    this.coreMaps.removeFromPendingOps(removeMe.getName());
                }
                removeMe = this.coreMaps.getCoreToClose();
            }
        }
    }
}

