/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrZkServerProps
extends QuorumPeerConfig {
    protected static Logger LOG = LoggerFactory.getLogger(QuorumPeerConfig.class);
    String solrPort;
    String zkRun;

    SolrZkServerProps() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String path) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(path);
        LOG.info("Reading configuration from: " + configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            try {
                cfg.load(in);
            }
            finally {
                in.close();
            }
            return cfg;
        }
        catch (IOException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + path, (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + path, (Exception)e);
        }
    }

    public static void injectServers(Properties props, String zkRun, String zkHost) {
        boolean hasServers;
        int portIdx;
        if (zkRun != null && props.getProperty("clientPort") == null && (portIdx = zkRun.lastIndexOf(58)) > 0) {
            String portStr = zkRun.substring(portIdx + 1);
            props.setProperty("clientPort", portStr);
        }
        if (!(hasServers = SolrZkServerProps.hasServers(props)) && zkHost != null) {
            int alg = Integer.parseInt(props.getProperty("electionAlg", "3").trim());
            String[] hosts = zkHost.split(",");
            int serverNum = 0;
            for (String hostAndPort : hosts) {
                hostAndPort = hostAndPort.trim();
                int portIdx2 = hostAndPort.lastIndexOf(58);
                String clientPortStr = hostAndPort.substring(portIdx2 + 1);
                int clientPort = Integer.parseInt(clientPortStr);
                String host = hostAndPort.substring(0, portIdx2);
                String serverStr = host + ':' + (clientPort + 1);
                if (alg != 0) {
                    serverStr = serverStr + ':' + (clientPort + 2);
                }
                props.setProperty("server." + serverNum, serverStr);
                ++serverNum;
            }
        }
    }

    public static boolean hasServers(Properties props) {
        for (Object key : props.keySet()) {
            if (!((String)key).startsWith("server.")) continue;
            return true;
        }
        return false;
    }

    public Long getMyServerId() {
        if (this.zkRun == null && this.solrPort == null) {
            return null;
        }
        Map slist = this.getServers();
        String myHost = "localhost";
        InetSocketAddress thisAddr = null;
        if (this.zkRun != null && this.zkRun.length() > 0) {
            String[] parts = this.zkRun.split(":");
            myHost = parts[0];
            thisAddr = new InetSocketAddress(myHost, Integer.parseInt(parts[1]) + 1);
        } else {
            thisAddr = new InetSocketAddress(myHost, Integer.parseInt(this.solrPort) + 1001);
        }
        Long me = null;
        boolean multiple = false;
        int port = 0;
        for (QuorumPeer.QuorumServer server : slist.values()) {
            if (!server.addr.getHostName().equals(myHost)) continue;
            multiple = me != null;
            me = server.id;
            port = server.addr.getPort();
        }
        if (!multiple) {
            this.setClientPort(port - 1);
            return me;
        }
        if (me == null) {
            return null;
        }
        for (QuorumPeer.QuorumServer server : slist.values()) {
            if (!server.addr.equals(thisAddr)) continue;
            if (this.clientPortAddress == null || this.clientPortAddress.getPort() <= 0) {
                this.setClientPort(server.addr.getPort() - 1);
            }
            return server.id;
        }
        return null;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setClientPort(int clientPort) {
        if (this.clientPortAddress != null) {
            try {
                this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(this.clientPortAddress.getHostName()), clientPort);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.clientPortAddress = new InetSocketAddress(clientPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseProperties(Properties zkProp) throws IOException, QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : zkProp.entrySet()) {
            String[] parts;
            long sid;
            int dot;
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.equals("dataDir")) {
                this.dataDir = value;
                continue;
            }
            if (key.equals("dataLogDir")) {
                this.dataLogDir = value;
                continue;
            }
            if (key.equals("clientPort")) {
                this.setClientPort(Integer.parseInt(value));
                continue;
            }
            if (key.equals("tickTime")) {
                this.tickTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("initLimit")) {
                this.initLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("server.")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                parts = value.split(":");
                if (parts.length != 2 && parts.length != 3) {
                    LOG.error(value + " does not have the form host:port or host:port:port");
                }
                InetSocketAddress addr = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
                if (parts.length == 2) {
                    this.servers.put(sid, new QuorumPeer.QuorumServer(sid, addr));
                    continue;
                }
                if (parts.length != 3) continue;
                InetSocketAddress electionAddr = new InetSocketAddress(parts[0], Integer.parseInt(parts[2]));
                this.servers.put(sid, new QuorumPeer.QuorumServer(sid, addr, electionAddr));
                continue;
            }
            if (key.startsWith("group")) {
                dot = key.indexOf(46);
                long gid = Long.parseLong(key.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid2 = Long.parseLong(s);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new QuorumPeerConfig.ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid);
                }
                continue;
            }
            if (key.startsWith("weight")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value));
                continue;
            }
            System.setProperty("zookeeper." + key, value);
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        } else if (!new File(this.dataLogDir).isDirectory()) {
            throw new IllegalArgumentException("dataLogDir " + this.dataLogDir + " is missing.");
        }
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        if (this.servers.size() > 1) {
            String myIdString;
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            if (this.electionAlg != 0) {
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (s.electionAddr != null) continue;
                    throw new IllegalArgumentException("Missing election port for server: " + s.id);
                }
            }
            if (this.serverGroup.size() > 0) {
                if (this.servers.size() != this.serverGroup.size()) {
                    throw new QuorumPeerConfig.ConfigException("Every server must be in exactly one group");
                }
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (this.serverWeight.containsKey(s.id)) continue;
                    this.serverWeight.put(s.id, 1L);
                }
                this.quorumVerifier = new QuorumHierarchical(this.numGroups, this.serverWeight, this.serverGroup);
            } else {
                LOG.info("Defaulting to majority quorums");
                this.quorumVerifier = new QuorumMaj(this.servers.size());
            }
            File myIdFile = new File(this.dataDir, "myid");
            if (!myIdFile.exists()) {
                Long myid = this.getMyServerId();
                if (myid != null) {
                    this.serverId = myid;
                    return;
                }
                if (this.zkRun == null) {
                    return;
                }
                throw new IllegalArgumentException(myIdFile.toString() + " file is missing");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(myIdFile), IOUtils.CHARSET_UTF_8));
            try {
                myIdString = br.readLine();
            }
            finally {
                br.close();
            }
            try {
                this.serverId = Long.parseLong(myIdString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("serverid " + myIdString + " is not a number");
            }
        }
    }
}

