/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

@Deprecated
public class LegacyHTMLStripCharFilter
extends BaseCharFilter {
    private int readAheadLimit = 8192;
    private int safeReadAheadLimit = this.readAheadLimit - 3;
    private int numWhitespace = 0;
    private int numRead = 0;
    private int numEaten = 0;
    private int numReturned = 0;
    private int lastMark;
    private Set<String> escapedTags;
    private final StringBuilder pushed = new StringBuilder();
    private static final int EOF = -1;
    private static final int MISMATCH = -2;
    private static final int MATCH = -3;
    private final StringBuilder sb = new StringBuilder();
    public static final int DEFAULT_READ_AHEAD = 8192;
    private static final HashMap<String, Character> entityTable = new HashMap();

    public static void main(String[] args) throws IOException {
        int ch;
        LegacyHTMLStripCharFilter in = new LegacyHTMLStripCharFilter(new InputStreamReader(System.in, Charset.defaultCharset()));
        while ((ch = ((Reader)((Object)in)).read()) != -1) {
            System.out.print((char)ch);
        }
    }

    public LegacyHTMLStripCharFilter(Reader source) {
        super(source.markSupported() ? source : new BufferedReader(source));
    }

    public LegacyHTMLStripCharFilter(Reader source, Set<String> escapedTags) {
        this(source);
        this.escapedTags = escapedTags;
    }

    public LegacyHTMLStripCharFilter(Reader source, Set<String> escapedTags, int readAheadLimit) {
        this(source);
        this.escapedTags = escapedTags;
        this.readAheadLimit = readAheadLimit;
        this.safeReadAheadLimit = readAheadLimit - 3;
    }

    public int getReadAheadLimit() {
        return this.readAheadLimit;
    }

    private int next() throws IOException {
        int len = this.pushed.length();
        if (len > 0) {
            char ch = this.pushed.charAt(len - 1);
            this.pushed.setLength(len - 1);
            return ch;
        }
        ++this.numRead;
        return this.input.read();
    }

    private int nextSkipWS() throws IOException {
        int ch = this.next();
        while (this.isSpace(ch)) {
            ch = this.next();
        }
        return ch;
    }

    private int peek() throws IOException {
        int len = this.pushed.length();
        if (len > 0) {
            return this.pushed.charAt(len - 1);
        }
        ++this.numRead;
        int ch = this.input.read();
        this.push(ch);
        return ch;
    }

    private void push(int ch) {
        this.pushed.append((char)ch);
    }

    private boolean isSpace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private boolean isHex(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }

    private boolean isAlpha(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    }

    private boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private boolean isIdChar(int ch) {
        return this.isAlpha(ch) || this.isDigit(ch) || ch == 46 || ch == 45 || ch == 95 || ch == 58 || Character.isLetter(ch);
    }

    private boolean isFirstIdChar(int ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    private void saveState() throws IOException {
        this.lastMark = this.numRead;
        this.input.mark(this.readAheadLimit);
    }

    private void restoreState() throws IOException {
        this.input.reset();
        this.pushed.setLength(0);
    }

    private int readNumericEntity() throws IOException {
        int eaten = 2;
        int ch = this.next();
        int base = 10;
        boolean invalid = false;
        this.sb.setLength(0);
        if (this.isDigit(ch)) {
            this.sb.append((char)ch);
            for (int i = 0; i < 10 && this.isDigit(ch = this.next()); ++i) {
                this.sb.append((char)ch);
            }
        } else if (ch == 120) {
            ++eaten;
            base = 16;
            this.sb.setLength(0);
            for (int i = 0; i < 10 && this.isHex(ch = this.next()); ++i) {
                this.sb.append((char)ch);
            }
        } else {
            return -2;
        }
        try {
            if (ch == 59 || ch == -1) {
                this.numWhitespace = this.sb.length() + eaten;
                return Integer.parseInt(this.sb.toString(), base);
            }
            if (this.isSpace(ch)) {
                this.push(ch);
                this.numWhitespace = this.sb.length() + eaten;
                return Integer.parseInt(this.sb.toString(), base);
            }
        }
        catch (NumberFormatException e) {
            return -2;
        }
        return -2;
    }

    private int readEntity() throws IOException {
        String entity;
        Character entityChar;
        int ch = this.next();
        if (ch == 35) {
            return this.readNumericEntity();
        }
        this.sb.setLength(0);
        this.sb.append((char)ch);
        for (int i = 0; i < this.safeReadAheadLimit && Character.isLetter(ch = this.next()); ++i) {
            this.sb.append((char)ch);
        }
        if (ch == 59 && (entityChar = entityTable.get(entity = this.sb.toString())) != null) {
            this.numWhitespace = entity.length() + 1;
            return entityChar.charValue();
        }
        return -2;
    }

    private int readBang(boolean inScript) throws IOException {
        int ret = this.readComment(inScript);
        if (ret == -3) {
            return -3;
        }
        if (this.numRead - this.lastMark < this.safeReadAheadLimit || this.peek() == 62) {
            int ch = this.next();
            if (ch == 62) {
                return -3;
            }
            while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
                ch = this.next();
                if (ch == 62) {
                    return -3;
                }
                if (ch >= 0) continue;
                return -2;
            }
        }
        return -2;
    }

    private int readComment(boolean inScript) throws IOException {
        int ch = this.next();
        if (ch != 45) {
            this.push(ch);
            return -2;
        }
        ch = this.next();
        if (ch != 45) {
            this.push(ch);
            this.push(45);
            return -2;
        }
        while (this.numRead - this.lastMark < this.safeReadAheadLimit - 3) {
            ch = this.next();
            if (ch < 0) {
                return -2;
            }
            if (ch == 45) {
                ch = this.next();
                if (ch < 0) {
                    return -2;
                }
                if (ch != 45) {
                    this.push(ch);
                    continue;
                }
                ch = this.next();
                if (ch < 0) {
                    return -2;
                }
                if (ch != 62) {
                    this.push(ch);
                    this.push(45);
                    continue;
                }
                return -3;
            }
            if ((ch == 39 || ch == 34) && inScript) {
                this.push(ch);
                int n = this.readScriptString();
                continue;
            }
            if (ch != 60) continue;
            this.eatSSI();
        }
        return -2;
    }

    private int readTag() throws IOException {
        String name;
        int ch = this.next();
        if (!this.isAlpha(ch)) {
            this.push(ch);
            return -2;
        }
        this.sb.setLength(0);
        this.sb.append((char)ch);
        while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
            ch = this.next();
            if (this.isIdChar(ch)) {
                this.sb.append((char)ch);
                continue;
            }
            if (ch != 47) break;
            return this.nextSkipWS() == 62 ? -3 : -2;
        }
        if (this.escapedTags != null && this.escapedTags.contains(this.sb.toString())) {
            return -2;
        }
        if (ch != 62 && !this.isSpace(ch)) {
            return -2;
        }
        if (ch != 62) {
            while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
                ch = this.next();
                if (this.isSpace(ch)) continue;
                if (this.isFirstIdChar(ch)) {
                    this.push(ch);
                    int ret = this.readAttr2();
                    if (ret != -2) continue;
                    return ret;
                }
                if (ch == 47) {
                    return this.nextSkipWS() == 62 ? -3 : -2;
                }
                if (ch == 62) break;
                return -2;
            }
            if (this.numRead - this.lastMark >= this.safeReadAheadLimit) {
                return -2;
            }
        }
        if ((name = this.sb.toString()).equalsIgnoreCase("script") || name.equalsIgnoreCase("style")) {
            this.saveState();
            this.pushed.setLength(0);
            return this.findEndTag();
        }
        return -3;
    }

    int findEndTag() throws IOException {
        while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
            int ret;
            int ch = this.next();
            if (ch == 60) {
                ch = this.next();
                if (ch == 33) {
                    ret = this.readBang(true);
                    if (ret != -3) continue;
                    continue;
                }
                if (ch != 47) {
                    this.push(ch);
                    continue;
                }
                ret = this.readName(false);
                if (ret == -2) {
                    return -2;
                }
                ch = this.nextSkipWS();
                if (ch != 62) {
                    return -2;
                }
                return -3;
            }
            if (ch == 39 || ch == 34) {
                this.push(ch);
                ret = this.readScriptString();
                if (ret != -2) continue;
                return -2;
            }
            if (ch >= 0) continue;
            return -2;
        }
        return -2;
    }

    private int readScriptString() throws IOException {
        int quoteChar = this.next();
        if (quoteChar != 39 && quoteChar != 34) {
            return -2;
        }
        while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
            int ch = this.next();
            if (ch == quoteChar) {
                return -3;
            }
            if (ch == 92) {
                ch = this.next();
                continue;
            }
            if (ch < 0) {
                return -2;
            }
            if (ch != 60) continue;
            this.eatSSI();
        }
        return -2;
    }

    private int readName(boolean checkEscaped) throws IOException {
        StringBuilder builder = checkEscaped && this.escapedTags != null ? new StringBuilder() : null;
        int ch = this.next();
        if (builder != null) {
            builder.append((char)ch);
        }
        if (!this.isFirstIdChar(ch)) {
            return -2;
        }
        ch = this.next();
        if (builder != null) {
            builder.append((char)ch);
        }
        while (this.isIdChar(ch)) {
            ch = this.next();
            if (builder == null) continue;
            builder.append((char)ch);
        }
        if (ch != -1) {
            this.push(ch);
        }
        if (builder != null && this.escapedTags.contains(builder.substring(0, builder.length() - 1))) {
            return -2;
        }
        return -3;
    }

    private int readAttr2() throws IOException {
        block13: {
            if (this.numRead - this.lastMark >= this.safeReadAheadLimit) break block13;
            int ch = this.next();
            if (!this.isFirstIdChar(ch)) {
                return -2;
            }
            ch = this.next();
            while (this.isIdChar(ch) && this.numRead - this.lastMark < this.safeReadAheadLimit) {
                ch = this.next();
            }
            if (this.isSpace(ch)) {
                ch = this.nextSkipWS();
            }
            if (ch != 61) {
                this.push(ch);
                return -3;
            }
            int quoteChar = this.nextSkipWS();
            if (quoteChar == 34 || quoteChar == 39) {
                while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
                    ch = this.next();
                    if (ch < 0) {
                        return -2;
                    }
                    if (ch == 60) {
                        this.eatSSI();
                        continue;
                    }
                    if (ch != quoteChar) continue;
                    return -3;
                }
            } else {
                while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
                    ch = this.next();
                    if (ch < 0) {
                        return -2;
                    }
                    if (this.isSpace(ch)) {
                        this.push(ch);
                        return -3;
                    }
                    if (ch == 62) {
                        this.push(ch);
                        return -3;
                    }
                    if (ch != 60) continue;
                    this.eatSSI();
                }
            }
        }
        return -2;
    }

    private int eatSSI() throws IOException {
        int ch = this.next();
        if (ch != 33) {
            this.push(ch);
            return -2;
        }
        ch = this.next();
        if (ch != 45) {
            this.push(ch);
            return -2;
        }
        ch = this.next();
        if (ch != 45) {
            this.push(ch);
            return -2;
        }
        ch = this.next();
        if (ch != 35) {
            this.push(ch);
            return -2;
        }
        this.push(35);
        this.push(45);
        this.push(45);
        return this.readComment(false);
    }

    private int readProcessingInstruction() throws IOException {
        while (this.numRead - this.lastMark < this.safeReadAheadLimit) {
            int ch = this.next();
            if (ch == 63 && this.peek() == 62) {
                this.next();
                return -3;
            }
            if (ch != -1) continue;
            return -2;
        }
        return -2;
    }

    public int read() throws IOException {
        int ch;
        if (this.numWhitespace > 0) {
            this.numEaten += this.numWhitespace;
            this.addOffCorrectMap(this.numReturned, this.numEaten);
            this.numWhitespace = 0;
        }
        ++this.numReturned;
        block4: while (true) {
            int lastNumRead = this.numRead;
            ch = this.next();
            switch (ch) {
                case 38: {
                    this.saveState();
                    ch = this.readEntity();
                    if (ch < 0) continue block4;
                    return ch;
                    if (ch != -2) continue block4;
                    this.restoreState();
                    return 38;
                }
                case 60: {
                    this.saveState();
                    ch = this.next();
                    int ret = -2;
                    if (ch == 33) {
                        ret = this.readBang(false);
                    } else if (ch == 47) {
                        ret = this.readName(true);
                        if (ret == -3) {
                            ch = this.nextSkipWS();
                            ret = ch == 62 ? -3 : -2;
                        }
                    } else if (this.isAlpha(ch)) {
                        this.push(ch);
                        ret = this.readTag();
                    } else if (ch == 63) {
                        ret = this.readProcessingInstruction();
                    }
                    if (ret == -3) {
                        this.numWhitespace = this.numRead - lastNumRead - 1;
                        return 32;
                    }
                    this.restoreState();
                    return 60;
                }
            }
            break;
        }
        return ch;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch;
        int i = 0;
        for (i = 0; i < len && (ch = this.read()) != -1; ++i) {
            cbuf[off++] = (char)ch;
        }
        if (i == 0) {
            if (len == 0) {
                return 0;
            }
            return -1;
        }
        return i;
    }

    static {
        String[] entityName = new String[]{"zwnj", "aring", "gt", "yen", "ograve", "Chi", "delta", "rang", "sup", "trade", "Ntilde", "xi", "upsih", "nbsp", "Atilde", "radic", "otimes", "aelig", "oelig", "equiv", "ni", "infin", "Psi", "auml", "cup", "Epsilon", "otilde", "lt", "Icirc", "Eacute", "Lambda", "sbquo", "Prime", "prime", "psi", "Kappa", "rsaquo", "Tau", "uacute", "ocirc", "lrm", "zwj", "cedil", "Alpha", "not", "amp", "AElig", "oslash", "acute", "lceil", "alefsym", "laquo", "shy", "loz", "ge", "Igrave", "nu", "Ograve", "lsaquo", "sube", "euro", "rarr", "sdot", "rdquo", "Yacute", "lfloor", "lArr", "Auml", "Dagger", "brvbar", "Otilde", "szlig", "clubs", "diams", "agrave", "Ocirc", "Iota", "Theta", "Pi", "zeta", "Scaron", "frac14", "egrave", "sub", "iexcl", "frac12", "ordf", "sum", "prop", "Uuml", "ntilde", "atilde", "asymp", "uml", "prod", "nsub", "reg", "rArr", "Oslash", "emsp", "THORN", "yuml", "aacute", "Mu", "hArr", "le", "thinsp", "dArr", "ecirc", "bdquo", "Sigma", "Aring", "tilde", "nabla", "mdash", "uarr", "times", "Ugrave", "Eta", "Agrave", "chi", "real", "circ", "eth", "rceil", "iuml", "gamma", "lambda", "harr", "Egrave", "frac34", "dagger", "divide", "Ouml", "image", "ndash", "hellip", "igrave", "Yuml", "ang", "alpha", "frasl", "ETH", "lowast", "Nu", "plusmn", "bull", "sup1", "sup2", "sup3", "Aacute", "cent", "oline", "Beta", "perp", "Delta", "there4", "pi", "iota", "empty", "euml", "notin", "iacute", "para", "epsilon", "weierp", "OElig", "uuml", "larr", "icirc", "Upsilon", "omicron", "upsilon", "copy", "Iuml", "Oacute", "Xi", "kappa", "ccedil", "Ucirc", "cap", "mu", "scaron", "lsquo", "isin", "Zeta", "minus", "deg", "and", "tau", "pound", "curren", "int", "ucirc", "rfloor", "ensp", "crarr", "ugrave", "exist", "cong", "theta", "oplus", "permil", "Acirc", "piv", "Euml", "Phi", "Iacute", "quot", "Uacute", "Omicron", "ne", "iquest", "eta", "rsquo", "yacute", "Rho", "darr", "Ecirc", "Omega", "acirc", "sim", "phi", "sigmaf", "macr", "thetasym", "Ccedil", "ordm", "uArr", "forall", "beta", "fnof", "rho", "micro", "eacute", "omega", "middot", "Gamma", "rlm", "lang", "spades", "supe", "thorn", "ouml", "or", "raquo", "part", "sect", "ldquo", "hearts", "sigma", "oacute"};
        char[] entityVal = new char[]{'\u200c', '\u00e5', '>', '\u00a5', '\u00f2', '\u03a7', '\u03b4', '\u232a', '\u2283', '\u2122', '\u00d1', '\u03be', '\u03d2', '\u00a0', '\u00c3', '\u221a', '\u2297', '\u00e6', '\u0153', '\u2261', '\u220b', '\u221e', '\u03a8', '\u00e4', '\u222a', '\u0395', '\u00f5', '<', '\u00ce', '\u00c9', '\u039b', '\u201a', '\u2033', '\u2032', '\u03c8', '\u039a', '\u203a', '\u03a4', '\u00fa', '\u00f4', '\u200e', '\u200d', '\u00b8', '\u0391', '\u00ac', '&', '\u00c6', '\u00f8', '\u00b4', '\u2308', '\u2135', '\u00ab', '\u00ad', '\u25ca', '\u2265', '\u00cc', '\u03bd', '\u00d2', '\u2039', '\u2286', '\u20ac', '\u2192', '\u22c5', '\u201d', '\u00dd', '\u230a', '\u21d0', '\u00c4', '\u2021', '\u00a6', '\u00d5', '\u00df', '\u2663', '\u2666', '\u00e0', '\u00d4', '\u0399', '\u0398', '\u03a0', '\u03b6', '\u0160', '\u00bc', '\u00e8', '\u2282', '\u00a1', '\u00bd', '\u00aa', '\u2211', '\u221d', '\u00dc', '\u00f1', '\u00e3', '\u2248', '\u00a8', '\u220f', '\u2284', '\u00ae', '\u21d2', '\u00d8', '\u2003', '\u00de', '\u00ff', '\u00e1', '\u039c', '\u21d4', '\u2264', '\u2009', '\u21d3', '\u00ea', '\u201e', '\u03a3', '\u00c5', '\u02dc', '\u2207', '\u2014', '\u2191', '\u00d7', '\u00d9', '\u0397', '\u00c0', '\u03c7', '\u211c', '\u02c6', '\u00f0', '\u2309', '\u00ef', '\u03b3', '\u03bb', '\u2194', '\u00c8', '\u00be', '\u2020', '\u00f7', '\u00d6', '\u2111', '\u2013', '\u2026', '\u00ec', '\u0178', '\u2220', '\u03b1', '\u2044', '\u00d0', '\u2217', '\u039d', '\u00b1', '\u2022', '\u00b9', '\u00b2', '\u00b3', '\u00c1', '\u00a2', '\u203e', '\u0392', '\u22a5', '\u0394', '\u2234', '\u03c0', '\u03b9', '\u2205', '\u00eb', '\u2209', '\u00ed', '\u00b6', '\u03b5', '\u2118', '\u0152', '\u00fc', '\u2190', '\u00ee', '\u03a5', '\u03bf', '\u03c5', '\u00a9', '\u00cf', '\u00d3', '\u039e', '\u03ba', '\u00e7', '\u00db', '\u2229', '\u03bc', '\u0161', '\u2018', '\u2208', '\u0396', '\u2212', '\u00b0', '\u2227', '\u03c4', '\u00a3', '\u00a4', '\u222b', '\u00fb', '\u230b', '\u2002', '\u21b5', '\u00f9', '\u2203', '\u2245', '\u03b8', '\u2295', '\u2030', '\u00c2', '\u03d6', '\u00cb', '\u03a6', '\u00cd', '\"', '\u00da', '\u039f', '\u2260', '\u00bf', '\u03b7', '\u2019', '\u00fd', '\u03a1', '\u2193', '\u00ca', '\u03a9', '\u00e2', '\u223c', '\u03c6', '\u03c2', '\u00af', '\u03d1', '\u00c7', '\u00ba', '\u21d1', '\u2200', '\u03b2', '\u0192', '\u03c1', '\u00b5', '\u00e9', '\u03c9', '\u00b7', '\u0393', '\u200f', '\u2329', '\u2660', '\u2287', '\u00fe', '\u00f6', '\u2228', '\u00bb', '\u2202', '\u00a7', '\u201c', '\u2665', '\u03c3', '\u00f3'};
        for (int i = 0; i < entityName.length; ++i) {
            entityTable.put(entityName[i], new Character(entityVal[i]));
        }
        entityTable.put("nbsp", new Character(' '));
    }
}

