/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.base.Validator;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;

public final class WriteAvroToByteArrayBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("writeAvroToByteArray");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new WriteAvroToByteArray(this, config, parent, child, context);
    }

    private static enum Format {
        container,
        containerlessJSON,
        containerlessBinary;

    }

    private static final class WriteAvroToByteArray
    extends AbstractCommand {
        private final Format format;
        private final CodecFactory codecFactory;
        private final Map<String, String> metadata = new HashMap<String, String>();

        public WriteAvroToByteArray(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.format = (Format)new Validator().validateEnum(config, this.getConfigs().getString(config, "format", Format.container.toString()), Format.class, (Enum[])new Format[0]);
            String codec = this.getConfigs().getString(config, "codec", null);
            this.codecFactory = codec == null ? null : CodecFactory.fromString((String)codec);
            Config metadataConfig = this.getConfigs().getConfig(config, "metadata", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(metadataConfig)) {
                this.metadata.put((String)entry.getKey(), entry.getValue().toString());
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord) {
            Record outputRecord = inputRecord.copy();
            AbstractParser.removeAttachments((Record)outputRecord);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            if (this.format == Format.container) {
                this.writeContainer(inputRecord, bout);
            } else {
                this.writeContainerless(inputRecord, bout);
            }
            outputRecord.put("_attachment_body", (Object)bout.toByteArray());
            return super.doProcess(outputRecord);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeContainer(Record src, OutputStream dst) {
            DataFileWriter dataFileWriter = null;
            try {
                try {
                    Schema schema = null;
                    for (Object attachment : src.get("_attachment_body")) {
                        Preconditions.checkNotNull(attachment);
                        GenericContainer datum = (GenericContainer)attachment;
                        schema = this.getSchema(datum, schema);
                        if (dataFileWriter == null) {
                            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
                            dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
                            if (this.codecFactory != null) {
                                dataFileWriter.setCodec(this.codecFactory);
                            }
                            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                                dataFileWriter.setMeta(entry.getKey(), entry.getValue());
                            }
                            dataFileWriter.create(schema, dst);
                        }
                        dataFileWriter.append((Object)datum);
                    }
                    if (dataFileWriter != null) {
                        dataFileWriter.flush();
                    }
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
            }
            finally {
                Closeables.closeQuietly(dataFileWriter);
            }
        }

        private void writeContainerless(Record src, OutputStream dst) {
            try {
                GenericDatumWriter datumWriter = new GenericDatumWriter();
                Object encoder = null;
                Schema schema = null;
                for (Object attachment : src.get("_attachment_body")) {
                    Preconditions.checkNotNull(attachment);
                    GenericContainer datum = (GenericContainer)attachment;
                    schema = this.getSchema(datum, schema);
                    datumWriter.setSchema(schema);
                    if (encoder == null) {
                        encoder = this.format == Format.containerlessJSON ? EncoderFactory.get().jsonEncoder(schema, dst) : EncoderFactory.get().binaryEncoder(dst, null);
                    }
                    datumWriter.write((Object)datum, encoder);
                }
                encoder.flush();
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
        }

        private Schema getSchema(GenericContainer datum, Schema lastSchema) {
            Schema schema = datum.getSchema();
            if (lastSchema != null && lastSchema != schema) {
                throw new MorphlineRuntimeException("Schemas must be identical: " + schema + ", lastSchema: " + lastSchema);
            }
            return schema;
        }
    }
}

