/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;

public final class ToAvroBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("toAvro");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToAvro(this, config, parent, child, context);
    }

    private static final class ToAvro
    extends AbstractCommand {
        private final Map<String, String> mappings = new HashMap<String, String>();
        private final Schema fixedSchema;
        private final String schemaField;
        private static final Object ERROR = new Object();

        public ToAvro(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String schemaFile = this.getConfigs().getString(config, "schemaFile", null);
            String schemaString = this.getConfigs().getString(config, "schemaString", null);
            this.schemaField = this.getConfigs().getString(config, "schemaField", null);
            int numDefinitions = 0;
            if (schemaFile != null) {
                ++numDefinitions;
            }
            if (schemaString != null) {
                ++numDefinitions;
            }
            if (this.schemaField != null) {
                ++numDefinitions;
            }
            if (numDefinitions == 0) {
                throw new MorphlineCompilationException("Either schemaFile or schemaString or schemaField must be defined", config);
            }
            if (numDefinitions > 1) {
                throw new MorphlineCompilationException("Must define only one of schemaFile or schemaString or schemaField at the same time", config);
            }
            if (schemaString != null) {
                this.fixedSchema = new Schema.Parser().parse(schemaString);
            } else if (schemaFile != null) {
                try {
                    this.fixedSchema = new Schema.Parser().parse(new File(schemaFile));
                }
                catch (IOException e) {
                    throw new MorphlineCompilationException("Cannot parse external Avro schema file: " + schemaFile, config, (Throwable)e);
                }
            } else {
                this.fixedSchema = null;
            }
            Config mappingsConfig = this.getConfigs().getConfig(config, "mappings", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(mappingsConfig)) {
                this.mappings.put((String)entry.getKey(), entry.getValue().toString());
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord) {
            Schema schema;
            if (this.schemaField != null) {
                schema = (Schema)inputRecord.getFirstValue(this.schemaField);
                Preconditions.checkNotNull((Object)schema);
            } else {
                schema = this.fixedSchema;
            }
            Record outputRecord = inputRecord.copy();
            AbstractParser.removeAttachments((Record)outputRecord);
            GenericData.Record avroRecord = new GenericData.Record(schema);
            for (Schema.Field field : schema.getFields()) {
                String morphlineFieldName = this.mappings.get(field.name());
                if (morphlineFieldName == null) {
                    morphlineFieldName = field.name();
                }
                List list = inputRecord.get(morphlineFieldName);
                Object avroResult = ERROR;
                if (field.schema().getType() == Schema.Type.ARRAY) {
                    avroResult = this.toAvro((Object)list, field);
                } else if (list.size() == 0) {
                    try {
                        avroResult = ReflectData.get().getDefaultValue(field);
                    }
                    catch (AvroRuntimeException e) {
                        avroResult = ERROR;
                    }
                } else if (list.size() == 1) {
                    avroResult = this.toAvro(list.get(0), field);
                }
                if (avroResult == ERROR) {
                    this.LOG.debug("Cannot convert item: {} to schema: {}", (Object)list, (Object)schema);
                    return false;
                }
                avroRecord.put(field.pos(), avroResult);
            }
            outputRecord.put("_attachment_body", (Object)avroRecord);
            return super.doProcess(outputRecord);
        }

        private static boolean nullOk(Schema schema) {
            if (Schema.Type.NULL == schema.getType()) {
                return true;
            }
            if (Schema.Type.UNION == schema.getType()) {
                for (Schema candidate : schema.getTypes()) {
                    if (!ToAvro.nullOk(candidate)) continue;
                    return true;
                }
            }
            return false;
        }

        private Object toAvro(Object item, Schema.Field field) {
            if (item == null && !ToAvro.nullOk(field.schema())) {
                try {
                    return ReflectData.get().getDefaultValue(field);
                }
                catch (AvroRuntimeException e) {
                    return ERROR;
                }
            }
            Object result = this.toAvro(item, field.schema());
            return result;
        }

        private Object toAvro(Object item, Schema schema) {
            switch (schema.getType()) {
                case RECORD: {
                    if (item instanceof Map) {
                        Map map = (Map)item;
                        GenericData.Record record = new GenericData.Record(schema);
                        for (Schema.Field field : schema.getFields()) {
                            Object value = map.get(field.name());
                            Object result = this.toAvro(value, field);
                            if (result == ERROR) {
                                return ERROR;
                            }
                            record.put(field.pos(), result);
                        }
                        return record;
                    }
                    return ERROR;
                }
                case ENUM: {
                    if (schema.hasEnumSymbol(item.toString())) {
                        return item.toString();
                    }
                    return ERROR;
                }
                case ARRAY: {
                    if (item instanceof List) {
                        ListIterator<Object> iter = ((List)item).listIterator();
                        while (iter.hasNext()) {
                            Object result = this.toAvro(iter.next(), schema.getElementType());
                            if (result == ERROR) {
                                return ERROR;
                            }
                            iter.set(result);
                        }
                        return item;
                    }
                    return ERROR;
                }
                case MAP: {
                    if (item instanceof Map) {
                        Map map = (Map)item;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry.getKey() instanceof CharSequence)) {
                                return ERROR;
                            }
                            Object result = this.toAvro(entry.getValue(), schema.getValueType());
                            if (result == ERROR) {
                                return ERROR;
                            }
                            entry.setValue(result);
                        }
                        return item;
                    }
                    return ERROR;
                }
                case UNION: {
                    return this.toAvroUnion(item, schema);
                }
                case FIXED: {
                    if (item instanceof byte[]) {
                        return new GenericData.Fixed(schema, (byte[])item);
                    }
                    return ERROR;
                }
                case STRING: {
                    assert (item != null);
                    return item.toString();
                }
                case BYTES: {
                    if (item instanceof ByteBuffer) {
                        return item;
                    }
                    if (item instanceof byte[]) {
                        return ByteBuffer.wrap((byte[])item);
                    }
                    return ERROR;
                }
                case INT: {
                    if (item instanceof Integer) {
                        return item;
                    }
                    if (item instanceof Number) {
                        return ((Number)item).intValue();
                    }
                    try {
                        return Integer.valueOf(item.toString());
                    }
                    catch (NumberFormatException e) {
                        return ERROR;
                    }
                }
                case LONG: {
                    if (item instanceof Long) {
                        return item;
                    }
                    if (item instanceof Number) {
                        return ((Number)item).longValue();
                    }
                    try {
                        return Long.valueOf(item.toString());
                    }
                    catch (NumberFormatException e) {
                        return ERROR;
                    }
                }
                case FLOAT: {
                    if (item instanceof Float) {
                        return item;
                    }
                    if (item instanceof Number) {
                        return Float.valueOf(((Number)item).floatValue());
                    }
                    try {
                        return Float.valueOf(item.toString());
                    }
                    catch (NumberFormatException e) {
                        return ERROR;
                    }
                }
                case DOUBLE: {
                    if (item instanceof Double) {
                        return item;
                    }
                    if (item instanceof Number) {
                        return ((Number)item).doubleValue();
                    }
                    try {
                        return Double.valueOf(item.toString());
                    }
                    catch (NumberFormatException e) {
                        return ERROR;
                    }
                }
                case BOOLEAN: {
                    if (item instanceof Boolean) {
                        return item;
                    }
                    assert (item != null);
                    String str = item.toString();
                    if ("true".equals(str)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equals(str)) {
                        return Boolean.FALSE;
                    }
                    return ERROR;
                }
                case NULL: {
                    if (item == null) {
                        return null;
                    }
                    return ERROR;
                }
            }
            throw new MorphlineRuntimeException("Unknown Avro schema type: " + schema.getType());
        }

        private Object toAvroUnion(Object item, Schema schema) {
            assert (schema.getType() == Schema.Type.UNION);
            List types = schema.getTypes();
            int index = -1;
            if (item instanceof Map) {
                for (int j = 0; j < types.size(); ++j) {
                    Schema.Type t = ((Schema)types.get(j)).getType();
                    if (t != Schema.Type.RECORD && t != Schema.Type.MAP) continue;
                    index = j;
                    break;
                }
            } else {
                try {
                    index = GenericData.get().resolveUnion(schema, item);
                }
                catch (AvroRuntimeException e) {
                    // empty catch block
                }
            }
            if (index >= 0) {
                Schema candidate = (Schema)types.get(index);
                Object result = this.toAvro(item, candidate);
                return result;
            }
            for (Schema candidate : types) {
                Object result = this.toAvro(item, candidate);
                if (result == ERROR) continue;
                return result;
            }
            return ERROR;
        }
    }
}

