/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.avro.FastGenericDatumReader;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.ResolvingDecoder;

public final class ReadAvroContainerBuilder
implements CommandBuilder {
    public static final String MIME_TYPE = "avro/binary";

    public Collection<String> getNames() {
        return Collections.singletonList("readAvroContainer");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadAvroContainer(this, config, parent, child, context);
    }

    static final class ForwardOnlySeekableInputStream
    implements SeekableInput {
        private final InputStream in;
        private long pos = 0L;

        public ForwardOnlySeekableInputStream(InputStream in) {
            this.in = in;
        }

        public long tell() throws IOException {
            return this.pos;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        public long length() throws IOException {
            throw new UnsupportedOperationException("Random access is not supported");
        }

        public void seek(long p) throws IOException {
            long todo = p - this.pos;
            if (todo < 0L) {
                throw new UnsupportedOperationException("Seeking backwards is not supported");
            }
            this.skip(todo);
        }

        private long skip(long len) throws IOException {
            long todo = len = Math.max(0L, len);
            while (todo > 0L) {
                long ret = this.in.skip(todo);
                if (ret == 0L) {
                    int b = this.in.read();
                    if (b == -1) {
                        throw new EOFException("Premature EOF from inputStream after skipping " + (len - todo) + " byte(s).");
                    }
                    ret = 1L;
                }
                todo -= ret;
                this.pos += ret;
            }
            return len;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private static final class ByteArrayKey {
        private byte[] bytes;

        public ByteArrayKey(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            ByteArrayKey otherKey = (ByteArrayKey)other;
            return Arrays.equals(this.bytes, otherKey.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    private static final class BoundedLRUHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        private BoundedLRUHashMap(int capacity) {
            super(16, 0.5f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }

    static class ReadAvroContainer
    extends AbstractParser {
        protected final Schema readerSchema;
        protected FastGenericDatumReader<GenericContainer> datumReader;
        private final Map<ByteArrayKey, ResolvingDecoder> resolverCache;

        public ReadAvroContainer(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String schemaString = this.getConfigs().getString(config, "readerSchemaString", null);
            if (schemaString != null) {
                this.readerSchema = new Schema.Parser().parse(schemaString);
            } else {
                String schemaFile = this.getConfigs().getString(config, "readerSchemaFile", null);
                if (schemaFile != null) {
                    try {
                        this.readerSchema = new Schema.Parser().parse(new File(schemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro reader schema file: " + schemaFile, config, (Throwable)e);
                    }
                } else {
                    this.readerSchema = null;
                }
            }
            if (((Object)((Object)this)).getClass() == ReadAvroContainer.class) {
                this.resolverCache = new BoundedLRUHashMap<ByteArrayKey, ResolvingDecoder>(this.getConfigs().getInt(config, "schemaCacheCapacity", 100));
                this.validateArguments();
            } else {
                this.resolverCache = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record inputRecord, InputStream in) throws IOException {
            if (this.datumReader == null) {
                this.datumReader = new FastGenericDatumReader(null, this.readerSchema);
            }
            DataFileReader reader = null;
            try {
                reader = new DataFileReader((SeekableInput)new ForwardOnlySeekableInputStream(in), this.datumReader);
                byte[] writerSchemaBytes = reader.getMeta("avro.schema");
                Preconditions.checkNotNull((Object)writerSchemaBytes);
                ByteArrayKey writerSchemaKey = new ByteArrayKey(writerSchemaBytes);
                ResolvingDecoder resolver = this.resolverCache.get(writerSchemaKey);
                if (resolver == null) {
                    resolver = this.createResolver(this.datumReader.getSchema(), this.datumReader.getExpected());
                    this.resolverCache.put(writerSchemaKey, resolver);
                    this.datumReader.setResolver(resolver);
                }
                Record template = inputRecord.copy();
                ReadAvroContainer.removeAttachments((Record)template);
                template.put("_attachment_mimetype", (Object)"avro/java+memory");
                while (reader.hasNext()) {
                    GenericContainer datum = (GenericContainer)reader.next();
                    if (this.extract(datum, template)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            return true;
        }

        protected ResolvingDecoder createResolver(Schema writerSchema, Schema readerSchema) throws IOException {
            return DecoderFactory.get().resolvingDecoder(Schema.applyAliases((Schema)writerSchema, (Schema)readerSchema), readerSchema, null);
        }

        protected boolean extract(GenericContainer datum, Record inputRecord) {
            this.incrementNumRecords();
            Record outputRecord = inputRecord.copy();
            outputRecord.put("_attachment_body", (Object)datum);
            return this.getChild().process(outputRecord);
        }
    }
}

