/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;

public final class ExtractAvroTreeBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("extractAvroTree");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractAvroTree(this, config, parent, child, context);
    }

    private static final class ExtractAvroTree
    extends AbstractCommand {
        private final String outputFieldPrefix;

        public ExtractAvroTree(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.outputFieldPrefix = this.getConfigs().getString(config, "outputFieldPrefix", "");
            this.validateArguments();
        }

        protected boolean doProcess(Record inputRecord) {
            GenericContainer datum = (GenericContainer)inputRecord.getFirstValue("_attachment_body");
            Preconditions.checkNotNull((Object)datum);
            Preconditions.checkNotNull((Object)datum.getSchema());
            Record outputRecord = inputRecord.copy();
            this.extractTree(datum, datum.getSchema(), outputRecord, this.outputFieldPrefix);
            return this.getChild().process(outputRecord);
        }

        private void extractTree(Object datum, Schema schema, Record outputRecord, String prefix) {
            switch (schema.getType()) {
                case RECORD: {
                    IndexedRecord avroRecord = (IndexedRecord)datum;
                    String prefix2 = prefix + "/";
                    for (Schema.Field field : schema.getFields()) {
                        this.extractTree(avroRecord.get(field.pos()), field.schema(), outputRecord, prefix2 + field.name());
                    }
                    break;
                }
                case ENUM: {
                    GenericEnumSymbol symbol = (GenericEnumSymbol)datum;
                    outputRecord.put(prefix, (Object)symbol.toString());
                    break;
                }
                case ARRAY: {
                    Iterator iter = ((Collection)datum).iterator();
                    while (iter.hasNext()) {
                        this.extractTree(iter.next(), schema.getElementType(), outputRecord, prefix);
                    }
                    break;
                }
                case MAP: {
                    Map map = (Map)datum;
                    for (Map.Entry entry : map.entrySet()) {
                        this.extractTree(entry.getValue(), schema.getValueType(), outputRecord, prefix + "/" + ((Object)((CharSequence)entry.getKey())).toString());
                    }
                    break;
                }
                case UNION: {
                    int index = GenericData.get().resolveUnion(schema, datum);
                    String prefix2 = prefix;
                    this.extractTree(datum, (Schema)schema.getTypes().get(index), outputRecord, prefix2);
                    break;
                }
                case FIXED: {
                    GenericFixed fixed = (GenericFixed)datum;
                    outputRecord.put(prefix, (Object)fixed.bytes());
                    break;
                }
                case BYTES: {
                    ByteBuffer buf = (ByteBuffer)datum;
                    int pos = buf.position();
                    byte[] bytes = new byte[buf.remaining()];
                    buf.get(bytes);
                    buf.position(pos);
                    outputRecord.put(prefix, (Object)bytes);
                    break;
                }
                case STRING: {
                    outputRecord.put(prefix, (Object)datum.toString());
                    break;
                }
                case INT: {
                    outputRecord.put(prefix, datum);
                    break;
                }
                case LONG: {
                    outputRecord.put(prefix, datum);
                    break;
                }
                case FLOAT: {
                    outputRecord.put(prefix, datum);
                    break;
                }
                case DOUBLE: {
                    outputRecord.put(prefix, datum);
                    break;
                }
                case BOOLEAN: {
                    outputRecord.put(prefix, datum);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new MorphlineRuntimeException("Unknown Avro schema type: " + schema.getType());
                }
            }
        }
    }
}

