/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flume.CounterGroup;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.PollableSource;
import org.apache.flume.Source;
import org.apache.flume.SourceRunner;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.lifecycle.LifecycleState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableSourceRunner
extends SourceRunner {
    private static final Logger logger = LoggerFactory.getLogger(PollableSourceRunner.class);
    private static final long backoffSleepIncrement = 1000L;
    private static final long maxBackoffSleep = 5000L;
    private AtomicBoolean shouldStop = new AtomicBoolean();
    private CounterGroup counterGroup = new CounterGroup();
    private PollingRunner runner;
    private Thread runnerThread;
    private LifecycleState lifecycleState = LifecycleState.IDLE;

    @Override
    public void start() {
        PollableSource source = (PollableSource)this.getSource();
        ChannelProcessor cp = source.getChannelProcessor();
        cp.initialize();
        source.start();
        this.runner = new PollingRunner();
        this.runner.source = source;
        this.runner.counterGroup = this.counterGroup;
        this.runner.shouldStop = this.shouldStop;
        this.runnerThread = new Thread(this.runner);
        this.runnerThread.setName(this.getClass().getSimpleName() + "-" + source.getClass().getSimpleName() + "-" + source.getName());
        this.runnerThread.start();
        this.lifecycleState = LifecycleState.START;
    }

    @Override
    public void stop() {
        this.runner.shouldStop.set(true);
        try {
            this.runnerThread.interrupt();
            this.runnerThread.join();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for polling runner to stop. Please report this.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Source source = this.getSource();
        source.stop();
        ChannelProcessor cp = source.getChannelProcessor();
        cp.close();
        this.lifecycleState = LifecycleState.STOP;
    }

    public String toString() {
        return "PollableSourceRunner: { source:" + this.getSource() + " counterGroup:" + this.counterGroup + " }";
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class PollingRunner
    implements Runnable {
        private PollableSource source;
        private AtomicBoolean shouldStop;
        private CounterGroup counterGroup;

        @Override
        public void run() {
            logger.debug("Polling runner starting. Source:{}", (Object)this.source);
            while (!this.shouldStop.get()) {
                this.counterGroup.incrementAndGet("runner.polls");
                try {
                    if (this.source.process().equals((Object)PollableSource.Status.BACKOFF)) {
                        this.counterGroup.incrementAndGet("runner.backoffs");
                        Thread.sleep(Math.min(this.counterGroup.incrementAndGet("runner.backoffs.consecutive") * 1000L, 5000L));
                        continue;
                    }
                    this.counterGroup.set("runner.backoffs.consecutive", 0L);
                }
                catch (InterruptedException e) {
                    logger.info("Source runner interrupted. Exiting");
                    this.counterGroup.incrementAndGet("runner.interruptions");
                }
                catch (EventDeliveryException e) {
                    logger.error("Unable to deliver event. Exception follows.", (Throwable)e);
                    this.counterGroup.incrementAndGet("runner.deliveryErrors");
                }
                catch (Exception e) {
                    this.counterGroup.incrementAndGet("runner.errors");
                    logger.error("Unhandled exception, logging and sleeping for 5000ms", (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            logger.debug("Polling runner exiting. Metrics:{}", (Object)this.counterGroup);
        }
    }
}

