/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZooKeeperDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDownloader.class);

    ZooKeeperDownloader() {
    }

    public SolrZkClient getZkClient(String zkHost) {
        SolrZkClient zkClient;
        if (zkHost == null) {
            throw new IllegalArgumentException("zkHost must not be null");
        }
        try {
            zkClient = new SolrZkClient(zkHost, 30000);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot connect to ZooKeeper: " + zkHost, e);
        }
        return zkClient;
    }

    public String readConfigName(SolrZkClient zkClient, String collection) throws KeeperException, InterruptedException {
        byte[] data;
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        String configName = null;
        byte[] aliasData = zkClient.getData("/aliases.json", null, null, true);
        Aliases aliases = ClusterState.load((byte[])aliasData);
        String alias = aliases.getCollectionAlias(collection);
        if (alias != null) {
            List aliasList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
            if (aliasList.size() > 1) {
                throw new IllegalArgumentException("collection cannot be an alias that maps to multiple collections");
            }
            collection = (String)aliasList.get(0);
        }
        String path = "/collections/" + collection;
        if (LOG.isInfoEnabled()) {
            LOG.info("Load collection config from:" + path);
        }
        if ((data = zkClient.getData(path, null, null, true)) != null) {
            ZkNodeProps props = ZkNodeProps.load((byte[])data);
            configName = props.getStr("configName");
        }
        if (configName != null && !zkClient.exists("/configs/" + configName, true).booleanValue()) {
            LOG.error("Specified config does not exist in ZooKeeper:" + configName);
            throw new IllegalArgumentException("Specified config does not exist in ZooKeeper:" + configName);
        }
        return configName;
    }

    public File downloadConfigDir(SolrZkClient zkClient, String configName, File dir) throws IOException, InterruptedException, KeeperException {
        Preconditions.checkArgument((boolean)dir.exists());
        Preconditions.checkArgument((boolean)dir.isDirectory());
        ZkController.downloadConfigDir((SolrZkClient)zkClient, (String)configName, (File)dir);
        File confDir = new File(dir, "conf");
        if (!confDir.isDirectory()) {
            confDir = new File(Files.createTempDir().getAbsolutePath(), "conf");
            confDir.getParentFile().deleteOnExit();
            Files.move((File)dir, (File)confDir);
            dir = confDir.getParentFile();
        }
        this.verifyConfigDir(confDir);
        return dir;
    }

    private void verifyConfigDir(File confDir) throws IOException {
        File solrConfigFile = new File(confDir, "solrconfig.xml");
        if (!solrConfigFile.exists()) {
            throw new IOException("Detected invalid Solr config dir in ZooKeeper - Reason: File not found: " + solrConfigFile.getName());
        }
        if (!solrConfigFile.isFile()) {
            throw new IOException("Detected invalid Solr config dir in ZooKeeper - Reason: Not a file: " + solrConfigFile.getName());
        }
        if (!solrConfigFile.canRead()) {
            throw new IOException("Insufficient permissions to read file: " + solrConfigFile);
        }
    }
}

