/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solr;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Notifications;
import com.cloudera.cdk.morphline.solr.SolrLocator;
import com.typesafe.config.Config;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public final class GenerateSolrSequenceKeyBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Arrays.asList("generateSolrSequenceKey", "sanitizeUniqueSolrKey");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new GenerateSolrSequenceKey(this, config, parent, child, context);
    }

    private static final class GenerateSolrSequenceKey
    extends AbstractCommand {
        private final boolean preserveExisting;
        private final String baseIdFieldName;
        private final String uniqueKeyName;
        private long recordCounter = 0L;
        private final String idPrefix;
        private final Random randomIdPrefix;

        public GenerateSolrSequenceKey(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.baseIdFieldName = this.getConfigs().getString(config, "baseIdField", "base_id");
            this.preserveExisting = this.getConfigs().getBoolean(config, "preserveExisting", true);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            IndexSchema schema = locator.getIndexSchema();
            SchemaField uniqueKey = schema.getUniqueKeyField();
            this.uniqueKeyName = uniqueKey == null ? null : uniqueKey.getName();
            String tmpIdPrefix = this.getConfigs().getString(config, "idPrefix", null);
            Random tmpRandomIdPrefx = null;
            if ("random".equals(tmpIdPrefix)) {
                tmpRandomIdPrefx = new Random(new SecureRandom().nextLong());
                tmpIdPrefix = null;
            }
            this.idPrefix = tmpIdPrefix;
            this.randomIdPrefix = tmpRandomIdPrefx;
            this.validateArguments();
        }

        protected boolean doProcess(Record doc) {
            String id;
            long num = this.recordCounter++;
            if (!(this.uniqueKeyName == null || this.preserveExisting && doc.getFields().containsKey((Object)this.uniqueKeyName))) {
                Object baseId = doc.getFirstValue(this.baseIdFieldName);
                if (baseId == null) {
                    throw new MorphlineRuntimeException("Record field " + this.baseIdFieldName + " must not be null as it is needed as a basis for a unique key for solr doc: " + doc);
                }
                doc.replaceValues(this.uniqueKeyName, (Object)(baseId.toString() + "#" + num));
            }
            if (this.idPrefix != null) {
                id = doc.getFirstValue(this.uniqueKeyName).toString();
                id = this.idPrefix + id;
                doc.replaceValues(this.uniqueKeyName, (Object)id);
            } else if (this.randomIdPrefix != null) {
                id = doc.getFirstValue(this.uniqueKeyName).toString();
                id = String.valueOf(Math.abs(this.randomIdPrefix.nextInt())) + "#" + id;
                doc.replaceValues(this.uniqueKeyName, (Object)id);
            }
            this.LOG.debug("record #{} unique key sanitized to this: {}", (Object)num, (Object)doc);
            return super.doProcess(doc);
        }

        protected void doNotify(Record notification) {
            if (Notifications.containsLifecycleEvent((Record)notification, (Notifications.LifecycleEvent)Notifications.LifecycleEvent.START_SESSION)) {
                this.recordCounter = 0L;
            }
            super.doNotify(notification);
        }
    }
}

