/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.SpellCheckMergeData;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;

public abstract class SolrSpellChecker {
    public static final String DICTIONARY_NAME = "name";
    public static final String DEFAULT_DICTIONARY_NAME = "default";
    public static final String FIELD = "field";
    public static final String FIELD_TYPE = "fieldType";
    protected String name;
    protected Analyzer analyzer;
    protected String field;
    protected String fieldTypeName;

    public String init(NamedList config, SolrCore core) {
        this.name = (String)config.get(DICTIONARY_NAME);
        if (this.name == null) {
            this.name = DEFAULT_DICTIONARY_NAME;
        }
        this.field = (String)config.get(FIELD);
        if (this.field != null && core.getSchema().getFieldTypeNoEx(this.field) != null) {
            this.analyzer = core.getSchema().getFieldType(this.field).getQueryAnalyzer();
        }
        this.fieldTypeName = (String)config.get(FIELD_TYPE);
        if (core.getSchema().getFieldTypes().containsKey(this.fieldTypeName)) {
            FieldType fieldType = core.getSchema().getFieldTypes().get(this.fieldTypeName);
            this.analyzer = fieldType.getQueryAnalyzer();
        }
        if (this.analyzer == null) {
            this.analyzer = new WhitespaceAnalyzer(core.getSolrConfig().luceneMatchVersion);
        }
        return this.name;
    }

    public SpellingResult mergeSuggestions(SpellCheckMergeData mergeData, int numSug, int count, boolean extendedResults) {
        float min = 0.5f;
        try {
            min = this.getAccuracy();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        LevensteinDistance sd = null;
        try {
            sd = this.getStringDistance() == null ? new LevensteinDistance() : this.getStringDistance();
        }
        catch (UnsupportedOperationException uoe) {
            sd = new LevensteinDistance();
        }
        SpellingResult result = new SpellingResult();
        for (Map.Entry<String, HashSet<String>> entry : mergeData.origVsSuggested.entrySet()) {
            int k;
            String original = entry.getKey();
            Integer numShards = mergeData.origVsShards.get(original);
            if (numShards < mergeData.totalNumberShardResponses) continue;
            HashSet<String> suggested = entry.getValue();
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
            for (String suggestion : suggested) {
                SuggestWord sug = mergeData.suggestedVsWord.get(suggestion);
                sug.score = sd.getDistance(original, sug.string);
                if (sug.score < min) continue;
                sugQueue.insertWithOverflow((Object)sug);
                if (sugQueue.size() != numSug) continue;
                min = ((SuggestWord)sugQueue.top()).score;
            }
            SpellCheckResponse.Suggestion suggestion = mergeData.origVsSuggestion.get(original);
            Token token = new Token(original, suggestion.getStartOffset(), suggestion.getEndOffset());
            SuggestWord[] suggestions = new SuggestWord[Math.min(count, sugQueue.size())];
            for (k = 0; k < sugQueue.size() - count; ++k) {
                sugQueue.pop();
            }
            for (k = Math.min(count, sugQueue.size()) - 1; k >= 0; --k) {
                suggestions[k] = (SuggestWord)sugQueue.pop();
            }
            if (extendedResults) {
                Integer o = mergeData.origVsFreq.get(original);
                if (o != null) {
                    result.addFrequency(token, o);
                }
                for (SuggestWord word : suggestions) {
                    result.add(token, word.string, word.freq);
                }
                continue;
            }
            ArrayList<String> words = new ArrayList<String>(sugQueue.size());
            for (SuggestWord word : suggestions) {
                words.add(word.string);
            }
            result.add(token, words);
        }
        return result;
    }

    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    public String getDictionaryName() {
        return this.name;
    }

    public abstract void reload(SolrCore var1, SolrIndexSearcher var2) throws IOException;

    public abstract void build(SolrCore var1, SolrIndexSearcher var2) throws IOException;

    protected float getAccuracy() {
        throw new UnsupportedOperationException();
    }

    protected StringDistance getStringDistance() {
        throw new UnsupportedOperationException();
    }

    public abstract SpellingResult getSuggestions(SpellingOptions var1) throws IOException;

    public boolean isSuggestionsMayOverlap() {
        return false;
    }
}

