/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.servlet.FormDataRequestParser;
import org.apache.solr.servlet.MultipartRequestParser;
import org.apache.solr.servlet.RawRequestParser;
import org.apache.solr.servlet.SimpleRequestParser;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.StandardRequestParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRequestParsers {
    final Logger log = LoggerFactory.getLogger(SolrRequestParsers.class);
    public static final String MULTIPART = "multipart";
    public static final String FORMDATA = "formdata";
    public static final String RAW = "raw";
    public static final String SIMPLE = "simple";
    public static final String STANDARD = "standard";
    private final HashMap<String, SolrRequestParser> parsers = new HashMap();
    private final boolean enableRemoteStreams;
    private StandardRequestParser standard;
    private boolean handleSelect = true;
    public static final SolrRequestParsers DEFAULT = new SolrRequestParsers();

    public SolrRequestParsers(Config globalConfig) {
        int multipartUploadLimitKB;
        int formUploadLimitKB;
        if (globalConfig == null) {
            formUploadLimitKB = Integer.MAX_VALUE;
            multipartUploadLimitKB = Integer.MAX_VALUE;
            this.enableRemoteStreams = true;
            this.handleSelect = true;
        } else {
            multipartUploadLimitKB = globalConfig.getInt("requestDispatcher/requestParsers/@multipartUploadLimitInKB", 2048);
            formUploadLimitKB = globalConfig.getInt("requestDispatcher/requestParsers/@formdataUploadLimitInKB", 2048);
            this.enableRemoteStreams = globalConfig.getBool("requestDispatcher/requestParsers/@enableRemoteStreaming", false);
            this.handleSelect = globalConfig.getBool("requestDispatcher/@handleSelect", true);
        }
        this.init(multipartUploadLimitKB, formUploadLimitKB);
    }

    private SolrRequestParsers() {
        this.enableRemoteStreams = false;
        this.handleSelect = false;
        this.init(2048, 2048);
    }

    private void init(int multipartUploadLimitKB, int formUploadLimitKB) {
        MultipartRequestParser multi = new MultipartRequestParser(multipartUploadLimitKB);
        RawRequestParser raw = new RawRequestParser();
        FormDataRequestParser formdata = new FormDataRequestParser(formUploadLimitKB);
        this.standard = new StandardRequestParser(multi, raw, formdata);
        this.parsers.put(MULTIPART, multi);
        this.parsers.put(FORMDATA, formdata);
        this.parsers.put(RAW, raw);
        this.parsers.put(SIMPLE, new SimpleRequestParser());
        this.parsers.put(STANDARD, this.standard);
        this.parsers.put("", this.standard);
    }

    public SolrQueryRequest parse(SolrCore core, String path, HttpServletRequest req) throws Exception {
        StandardRequestParser parser = this.standard;
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        SolrParams params = parser.parseParamsAndFillStreams(req, streams);
        SolrQueryRequest sreq = this.buildRequestFrom(core, params, streams);
        sreq.getContext().put("path", path);
        return sreq;
    }

    public SolrQueryRequest buildRequestFrom(SolrCore core, SolrParams params, Collection<ContentStream> streams) throws Exception {
        ContentStreamBase.URLStream stream;
        String contentType = params.get("stream.contentType");
        String[] strs = params.getParams("stream.url");
        if (strs != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled.");
            }
            for (String url : strs) {
                stream = new ContentStreamBase.URLStream(new URL(url));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.file")) != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled.");
            }
            for (String file : strs) {
                stream = new ContentStreamBase.FileStream(new File(file));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.body")) != null) {
            for (String body : strs) {
                stream = new ContentStreamBase.StringStream(body);
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        SolrQueryRequestBase q = new SolrQueryRequestBase(core, params){};
        if (streams != null && streams.size() > 0) {
            q.setContentStreams(streams);
        }
        return q;
    }

    public static MultiMapSolrParams parseQueryString(String queryString) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        SolrRequestParsers.parseQueryString(queryString, map);
        return new MultiMapSolrParams(map);
    }

    static void parseQueryString(final String queryString, Map<String, String[]> map) {
        if (queryString != null && queryString.length() > 0) {
            try {
                final int len = queryString.length();
                InputStream in = new InputStream(){
                    int pos = 0;

                    @Override
                    public int read() {
                        if (this.pos < len) {
                            char ch = queryString.charAt(this.pos);
                            if (ch > '\u007f') {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: The query string contains a not-%-escaped byte > 127 at position " + this.pos);
                            }
                            ++this.pos;
                            return ch;
                        }
                        return -1;
                    }
                };
                SolrRequestParsers.parseFormDataContent(in, Long.MAX_VALUE, IOUtils.CHARSET_UTF_8, map);
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ioe);
            }
        }
    }

    static long parseFormDataContent(InputStream postContent, long maxLen, Charset charset, Map<String, String[]> map) throws IOException {
        long len;
        block11: {
            CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            len = 0L;
            long keyPos = 0L;
            long valuePos = 0L;
            ByteArrayOutputStream2 keyStream = new ByteArrayOutputStream2();
            ByteArrayOutputStream2 valueStream = new ByteArrayOutputStream2();
            ByteArrayOutputStream2 currentStream = keyStream;
            do {
                int b = postContent.read();
                switch (b) {
                    case -1: 
                    case 38: {
                        if (keyStream.size() > 0) {
                            String key = SolrRequestParsers.decodeChars(keyStream, keyPos, charsetDecoder);
                            String value = SolrRequestParsers.decodeChars(valueStream, valuePos, charsetDecoder);
                            MultiMapSolrParams.addParam((String)key, (String)value, map);
                        } else if (valueStream.size() > 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded invalid: missing key");
                        }
                        keyStream.reset();
                        valueStream.reset();
                        keyPos = valuePos = len + 1L;
                        currentStream = keyStream;
                        break;
                    }
                    case 43: {
                        currentStream.write(32);
                        break;
                    }
                    case 37: {
                        b = postContent.read();
                        int upper = SolrRequestParsers.digit16(b);
                        ++len;
                        b = postContent.read();
                        int lower = SolrRequestParsers.digit16(b);
                        ++len;
                        currentStream.write((upper << 4) + lower);
                        break;
                    }
                    case 61: {
                        if (currentStream == keyStream) {
                            valuePos = len + 1L;
                            currentStream = valueStream;
                            break;
                        }
                    }
                    default: {
                        currentStream.write(b);
                    }
                }
                if (b == -1) break block11;
            } while (++len <= maxLen);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "application/x-www-form-urlencoded content exceeds upload limit of " + maxLen / 1024L + " KB");
        }
        return len;
    }

    private static String decodeChars(ByteArrayOutputStream2 stream, long position, CharsetDecoder charsetDecoder) {
        try {
            return charsetDecoder.decode(ByteBuffer.wrap(stream.buffer(), 0, stream.size())).toString();
        }
        catch (CharacterCodingException cce) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Invalid character encoding detected after position " + position + " of query string / form data (while parsing as " + charsetDecoder.charset().name() + ")");
        }
    }

    private static int digit16(int b) {
        if (b == -1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Incomplete trailing escape (%) pattern");
        }
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 55;
        }
        if (b >= 97 && b <= 102) {
            return b - 87;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "URLDecoder: Invalid digit (" + (char)b + ") in escape (%) pattern");
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public void setHandleSelect(boolean handleSelect) {
        this.handleSelect = handleSelect;
    }

    static final class ByteArrayOutputStream2
    extends ByteArrayOutputStream {
        ByteArrayOutputStream2() {
        }

        byte[] buffer() {
            return this.buf;
        }
    }
}

