/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;

class SpatialDistanceQuery
extends ExtendedQueryBase
implements PostFilter {
    String origField;
    ValueSource latSource;
    ValueSource lonSource;
    double lonMin;
    double lonMax;
    double lon2Min;
    double lon2Max;
    double latMin;
    double latMax;
    boolean lon2;
    boolean calcDist;
    Query bboxQuery;
    double latCenter;
    double lonCenter;
    double dist;
    double planetRadius;

    SpatialDistanceQuery() {
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.bboxQuery != null ? this.bboxQuery.rewrite(reader) : this;
    }

    public void extractTerms(Set terms) {
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        try {
            return new SpatialCollector(new SpatialWeight(searcher));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        assert (this.bboxQuery == null);
        return new SpatialWeight(searcher);
    }

    @Override
    public String toString(String field) {
        float boost = this.getBoost();
        return super.getOptions() + ((double)boost != 1.0 ? "(" : "") + (this.calcDist ? "geofilt" : "bbox") + "(latlonSource=" + this.origField + "(" + this.latSource + "," + this.lonSource + ")" + ",latCenter=" + this.latCenter + ",lonCenter=" + this.lonCenter + ",dist=" + this.dist + ",latMin=" + this.latMin + ",latMax=" + this.latMax + ",lonMin=" + this.lonMin + ",lonMax" + this.lonMax + ",lon2Min=" + this.lon2Min + ",lon2Max" + this.lon2Max + ",calcDist=" + this.calcDist + ",planetRadius=" + this.planetRadius + ")" + ((double)boost == 1.0 ? "" : ")^" + boost);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpatialDistanceQuery other = (SpatialDistanceQuery)o;
        return this.latCenter == other.latCenter && this.lonCenter == other.lonCenter && this.latMin == other.latMin && this.latMax == other.latMax && this.lonMin == other.lonMin && this.lonMax == other.lonMax && this.lon2Min == other.lon2Min && this.lon2Max == other.lon2Max && this.dist == other.dist && this.planetRadius == other.planetRadius && this.calcDist == other.calcDist && this.lonSource.equals((Object)other.lonSource) && this.latSource.equals((Object)other.latSource) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.latCenter);
        hash = hash * 31L + Double.doubleToLongBits(this.lonMin);
        hash = hash * 31L + (long)super.hashCode();
        return (int)(hash >> (int)(32L + hash));
    }

    class SpatialCollector
    extends DelegatingCollector {
        final SpatialWeight weight;
        SpatialScorer spatialScorer;
        int maxdoc;

        public SpatialCollector(SpatialWeight weight) {
            this.weight = weight;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.spatialScorer.doc = doc;
            if (this.spatialScorer.match()) {
                this.delegate.collect(doc);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.maxdoc = context.reader().maxDoc();
            this.spatialScorer = new SpatialScorer(context, null, this.weight, 1.0f);
            super.setNextReader(context);
        }
    }

    protected class SpatialScorer
    extends Scorer {
        final IndexReader reader;
        final SpatialWeight weight;
        final int maxDoc;
        final float qWeight;
        int doc;
        final FunctionValues latVals;
        final FunctionValues lonVals;
        final Bits acceptDocs;
        final double lonMin;
        final double lonMax;
        final double lon2Min;
        final double lon2Max;
        final double latMin;
        final double latMax;
        final boolean lon2;
        final boolean calcDist;
        final double latCenterRad;
        final double lonCenterRad;
        final double latCenterRad_cos;
        final double dist;
        final double planetRadius;
        int lastDistDoc;
        double lastDist;

        public SpatialScorer(AtomicReaderContext readerContext, Bits acceptDocs, SpatialWeight w, float qWeight) throws IOException {
            super((Weight)w);
            this.doc = -1;
            this.weight = w;
            this.qWeight = qWeight;
            this.reader = readerContext.reader();
            this.maxDoc = this.reader.maxDoc();
            this.acceptDocs = acceptDocs;
            this.latVals = SpatialDistanceQuery.this.latSource.getValues(this.weight.latContext, readerContext);
            this.lonVals = SpatialDistanceQuery.this.lonSource.getValues(this.weight.lonContext, readerContext);
            this.lonMin = SpatialDistanceQuery.this.lonMin;
            this.lonMax = SpatialDistanceQuery.this.lonMax;
            this.lon2Min = SpatialDistanceQuery.this.lon2Min;
            this.lon2Max = SpatialDistanceQuery.this.lon2Max;
            this.latMin = SpatialDistanceQuery.this.latMin;
            this.latMax = SpatialDistanceQuery.this.latMax;
            this.lon2 = SpatialDistanceQuery.this.lon2;
            this.calcDist = SpatialDistanceQuery.this.calcDist;
            this.latCenterRad = SpatialDistanceQuery.this.latCenter * (Math.PI / 180);
            this.lonCenterRad = SpatialDistanceQuery.this.lonCenter * (Math.PI / 180);
            this.latCenterRad_cos = this.calcDist ? Math.cos(this.latCenterRad) : 0.0;
            this.dist = SpatialDistanceQuery.this.dist;
            this.planetRadius = SpatialDistanceQuery.this.planetRadius;
        }

        boolean match() {
            double lon = this.lonVals.doubleVal(this.doc);
            if (!(lon >= this.lonMin && lon <= this.lonMax || this.lon2 && lon >= this.lon2Min && lon <= this.lon2Max)) {
                return false;
            }
            double lat = this.latVals.doubleVal(this.doc);
            if (!(lat >= this.latMin) || !(lat <= this.latMax)) {
                return false;
            }
            if (!this.calcDist) {
                return true;
            }
            return this.dist(lat, lon) <= this.dist;
        }

        double dist(double lat, double lon) {
            double latRad = lat * (Math.PI / 180);
            double lonRad = lon * (Math.PI / 180);
            double diffX = this.latCenterRad - latRad;
            double diffY = this.lonCenterRad - lonRad;
            double hsinX = Math.sin(diffX * 0.5);
            double hsinY = Math.sin(diffY * 0.5);
            double h = hsinX * hsinX + this.latCenterRad_cos * Math.cos(latRad) * hsinY * hsinY;
            double result = this.planetRadius * 2.0 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
            this.lastDistDoc = this.doc;
            this.lastDist = result;
            return result;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (this.acceptDocs != null && !this.acceptDocs.get(this.doc) || !this.match());
            return this.doc;
        }

        public int advance(int target) throws IOException {
            this.doc = target - 1;
            return this.nextDoc();
        }

        public float score() throws IOException {
            double dist = this.doc == this.lastDistDoc ? this.lastDist : this.dist(this.latVals.doubleVal(this.doc), this.lonVals.doubleVal(this.doc));
            return (float)(dist * (double)this.qWeight);
        }

        public int freq() throws IOException {
            return 1;
        }

        public long cost() {
            return this.maxDoc;
        }

        public Explanation explain(int doc) throws IOException {
            this.advance(doc);
            boolean matched = this.doc == doc;
            this.doc = doc;
            float sc = matched ? this.score() : 0.0f;
            double dist = this.dist(this.latVals.doubleVal(doc), this.lonVals.doubleVal(doc));
            String description = SpatialDistanceQuery.this.toString();
            ComplexExplanation result = new ComplexExplanation(this.doc == doc, sc, description + " product of:");
            result.addDetail(new Explanation((float)dist, "hsin(" + this.latVals.doubleVal(doc) + "," + this.lonVals.doubleVal(doc)));
            result.addDetail(new Explanation(SpatialDistanceQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    protected class SpatialWeight
    extends Weight {
        protected IndexSearcher searcher;
        protected float queryNorm;
        protected float queryWeight;
        protected Map latContext;
        protected Map lonContext;

        public SpatialWeight(IndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.latContext = ValueSource.newContext((IndexSearcher)searcher);
            this.lonContext = ValueSource.newContext((IndexSearcher)searcher);
            SpatialDistanceQuery.this.latSource.createWeight(this.latContext, searcher);
            SpatialDistanceQuery.this.lonSource.createWeight(this.lonContext, searcher);
        }

        public Query getQuery() {
            return SpatialDistanceQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = SpatialDistanceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            return new SpatialScorer(context, acceptDocs, this, this.queryWeight);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return ((SpatialScorer)this.scorer(context, true, true, context.reader().getLiveDocs())).explain(doc);
        }
    }
}

