/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResourceLoader
implements ResourceLoader {
    public static final Logger log = LoggerFactory.getLogger(SolrResourceLoader.class);
    static final String project = "solr";
    static final String base = "org.apache.solr";
    static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "search.", "update.", "core.", "response.", "request.", "update.processor.", "util.", "spelling.", "handler.component.", "handler.dataimport."};
    protected URLClassLoader classLoader;
    private final String instanceDir;
    private String dataDir;
    private final List<SolrCoreAware> waitingForCore = Collections.synchronizedList(new ArrayList());
    private final List<SolrInfoMBean> infoMBeans = Collections.synchronizedList(new ArrayList());
    private final List<org.apache.lucene.analysis.util.ResourceLoaderAware> waitingForResources = Collections.synchronizedList(new ArrayList());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Properties coreProperties;
    private volatile boolean live;
    private static final Map<String, String> classNameCache = new ConcurrentHashMap<String, String>();
    private static final Pattern legacyAnalysisPattern = Pattern.compile("((\\Qorg.apache.solr.analysis.\\E)|(\\Qsolr.\\E))([\\p{L}_$][\\p{L}\\p{N}_$]+?)(TokenFilter|Filter|Tokenizer|CharFilter)Factory");
    static final String[] empty = new String[0];
    private static final Map<Class, Class[]> awareCompatibility = new HashMap<Class, Class[]>();

    public SolrResourceLoader(String instanceDir, ClassLoader parent, Properties coreProperties) {
        if (instanceDir == null) {
            this.instanceDir = SolrResourceLoader.locateSolrHome();
            log.info("new SolrResourceLoader for deduced Solr Home: '{}'", (Object)this.instanceDir);
        } else {
            this.instanceDir = SolrResourceLoader.normalizeDir(instanceDir);
            log.info("new SolrResourceLoader for directory: '{}'", (Object)this.instanceDir);
        }
        this.classLoader = SolrResourceLoader.createClassLoader(null, parent);
        this.addToClassLoader("./lib/", null, true);
        this.reloadLuceneSPI();
        this.coreProperties = coreProperties;
    }

    public SolrResourceLoader(String instanceDir, ClassLoader parent) {
        this(instanceDir, parent, null);
    }

    void addToClassLoader(String baseDir, FileFilter filter, boolean quiet) {
        File base = FileUtils.resolvePath(new File(this.getInstanceDir()), baseDir);
        if (base != null && base.exists() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (!(quiet || files != null && files.length != 0)) {
                log.warn("No files added to classloader from lib: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
            } else {
                this.classLoader = SolrResourceLoader.replaceClassLoader(this.classLoader, base, filter);
            }
        } else if (!quiet) {
            log.warn("Can't find (or read) directory to add to classloader: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
        }
    }

    void addToClassLoader(String path) {
        final File file = FileUtils.resolvePath(new File(this.getInstanceDir()), path);
        if (file.canRead()) {
            this.classLoader = SolrResourceLoader.replaceClassLoader(this.classLoader, file.getParentFile(), new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.equals(file);
                }
            });
        } else {
            log.error("Can't find (or read) file to add to classloader: " + file);
        }
    }

    void reloadLuceneSPI() {
        PostingsFormat.reloadPostingsFormats((ClassLoader)this.classLoader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)this.classLoader);
        Codec.reloadCodecs((ClassLoader)this.classLoader);
        CharFilterFactory.reloadCharFilters((ClassLoader)this.classLoader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)this.classLoader);
        TokenizerFactory.reloadTokenizers((ClassLoader)this.classLoader);
    }

    private static URLClassLoader replaceClassLoader(URLClassLoader oldLoader, File base, FileFilter filter) {
        if (null != base && base.canRead() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (null == files || 0 == files.length) {
                return oldLoader;
            }
            URL[] oldElements = oldLoader.getURLs();
            URL[] elements = new URL[oldElements.length + files.length];
            System.arraycopy(oldElements, 0, elements, 0, oldElements.length);
            for (int j = 0; j < files.length; ++j) {
                try {
                    URL element = files[j].toURI().normalize().toURL();
                    log.info("Adding '" + element.toString() + "' to classloader");
                    elements[oldElements.length + j] = element;
                    continue;
                }
                catch (MalformedURLException e) {
                    SolrException.log((Logger)log, (String)("Can't add element to classloader: " + files[j]), (Throwable)e);
                }
            }
            return URLClassLoader.newInstance(elements, oldLoader.getParent());
        }
        return oldLoader;
    }

    static URLClassLoader createClassLoader(File libDir, ClassLoader parent) {
        if (null == parent) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        return SolrResourceLoader.replaceClassLoader(URLClassLoader.newInstance(new URL[0], parent), libDir, null);
    }

    public SolrResourceLoader(String instanceDir) {
        this(instanceDir, null, null);
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + File.separator : path;
    }

    public String[] listConfigDir() {
        File configdir = new File(this.getConfigDir());
        if (configdir.exists() && configdir.isDirectory()) {
            return configdir.list();
        }
        return new String[0];
    }

    public String getConfigDir() {
        return this.instanceDir + "conf/";
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Properties getCoreProperties() {
        return this.coreProperties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public InputStream openSchema(String name) throws IOException {
        return this.openResource(name);
    }

    public InputStream openConfig(String name) throws IOException {
        return this.openResource(name);
    }

    public InputStream openResource(String resource) throws IOException {
        InputStream is = null;
        try {
            File f0;
            File f = f0 = new File(resource);
            if (!f.isAbsolute()) {
                f = new File(this.getConfigDir() + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            if (f != f0 && f0.isFile() && f0.canRead()) {
                return new FileInputStream(f0);
            }
            is = this.classLoader.getResourceAsStream(resource);
            if (is == null) {
                is = this.classLoader.getResourceAsStream(this.getConfigDir() + resource);
            }
        }
        catch (Exception e) {
            throw new IOException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new IOException("Can't find resource '" + resource + "' in classpath or '" + this.getConfigDir() + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public List<String> getLines(String resource) throws IOException {
        return this.getLines(resource, UTF_8);
    }

    public List<String> getLines(String resource, String encoding) throws IOException {
        return this.getLines(resource, Charset.forName(encoding));
    }

    public List<String> getLines(String resource, Charset charset) throws IOException {
        try {
            return WordlistLoader.getLines((InputStream)this.openResource(resource), (Charset)charset);
        }
        catch (CharacterCodingException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading resource (wrong encoding?): " + resource, (Throwable)ex);
        }
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.findClass(cname, expectedType, empty);
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType, String ... subpackages) {
        Object name;
        if (subpackages == null || subpackages.length == 0 || subpackages == packages) {
            subpackages = packages;
            String c = classNameCache.get(cname);
            if (c != null) {
                try {
                    return Class.forName(c, true, this.classLoader).asSubclass(expectedType);
                }
                catch (ClassNotFoundException e) {
                    log.error("Unable to load cached class-name :  " + c + " for shortname : " + cname + e);
                }
            }
        }
        Class<T> clazz = null;
        Matcher m = legacyAnalysisPattern.matcher(cname);
        if (m.matches()) {
            name = m.group(4);
            log.trace("Trying to load class from analysis SPI using name='{}'", name);
            try {
                if (CharFilterFactory.class.isAssignableFrom(expectedType)) {
                    clazz = CharFilterFactory.lookupClass((String)name).asSubclass(expectedType);
                    return clazz;
                }
                if (TokenizerFactory.class.isAssignableFrom(expectedType)) {
                    clazz = TokenizerFactory.lookupClass((String)name).asSubclass(expectedType);
                    return clazz;
                }
                if (TokenFilterFactory.class.isAssignableFrom(expectedType)) {
                    clazz = TokenFilterFactory.lookupClass((String)name).asSubclass(expectedType);
                    return clazz;
                }
                log.warn("'{}' looks like an analysis factory, but caller requested different class type: {}", (Object)cname, (Object)expectedType.getName());
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        try {
            name = Class.forName(cname, true, this.classLoader).asSubclass(expectedType);
            return name;
        }
        catch (ClassNotFoundException e) {
            String newName = cname;
            if (newName.startsWith(project)) {
                newName = cname.substring(project.length() + 1);
            }
            for (String subpackage : subpackages) {
                try {
                    String name2 = "org.apache.solr." + subpackage + newName;
                    log.trace("Trying class name " + name2);
                    clazz = Class.forName(name2, true, this.classLoader).asSubclass(expectedType);
                    Class<T> clazz2 = clazz;
                    return clazz2;
                }
                catch (ClassNotFoundException e1) {
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading class '" + cname + "'", (Throwable)e);
        }
        finally {
            if (!(clazz == null || clazz.getClassLoader() != SolrResourceLoader.class.getClassLoader() || cname.equals(clazz.getName()) || subpackages.length != 0 && subpackages != packages)) {
                classNameCache.put(cname, clazz.getName());
            }
        }
    }

    public <T> T newInstance(String name, Class<T> expectedType) {
        return this.newInstance(name, expectedType, empty);
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String ... subpackages) {
        Class<T> clazz = this.findClass(cname, expectedType, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader);
        }
        T obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                this.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add((SolrCoreAware)obj);
            }
            if (ResourceLoaderAware.class.isInstance(obj)) {
                log.warn("Class [{}] uses org.apache.solr.util.plugin.ResourceLoaderAware which is deprecated. Change to org.apache.lucene.analysis.util.ResourceLoaderAware.", (Object)cname);
            }
            if (obj instanceof org.apache.lucene.analysis.util.ResourceLoaderAware) {
                this.assertAwareCompatibility(org.apache.lucene.analysis.util.ResourceLoaderAware.class, obj);
                this.waitingForResources.add((org.apache.lucene.analysis.util.ResourceLoaderAware)obj);
            }
            if (obj instanceof SolrInfoMBean) {
                this.infoMBeans.add((SolrInfoMBean)obj);
            }
        }
        return obj;
    }

    public CoreAdminHandler newAdminHandlerInstance(CoreContainer coreContainer, String cname, String ... subpackages) {
        Class<CoreAdminHandler> clazz = this.findClass(cname, CoreAdminHandler.class, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader);
        }
        CoreAdminHandler obj = null;
        try {
            Constructor<CoreAdminHandler> ctor = clazz.getConstructor(CoreContainer.class);
            obj = ctor.newInstance(coreContainer);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        if (!this.live) {
            if (ResourceLoaderAware.class.isInstance(obj)) {
                log.warn("Class [{}] uses org.apache.solr.util.plugin.ResourceLoaderAware which is deprecated. Change to org.apache.lucene.analysis.util.ResourceLoaderAware.", (Object)cname);
            }
            if (obj instanceof org.apache.lucene.analysis.util.ResourceLoaderAware) {
                this.assertAwareCompatibility(org.apache.lucene.analysis.util.ResourceLoaderAware.class, obj);
                this.waitingForResources.add((org.apache.lucene.analysis.util.ResourceLoaderAware)obj);
            }
        }
        return obj;
    }

    public <T> T newInstance(String cName, Class<T> expectedType, String[] subPackages, Class[] params, Object[] args) {
        Class<T> clazz = this.findClass(cName, expectedType, subPackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cName + " in " + this.classLoader);
        }
        T obj = null;
        try {
            Constructor<T> constructor = clazz.getConstructor(params);
            obj = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                this.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add((SolrCoreAware)obj);
            }
            if (ResourceLoaderAware.class.isInstance(obj)) {
                log.warn("Class [{}] uses org.apache.solr.util.plugin.ResourceLoaderAware which is deprecated. Change to org.apache.lucene.analysis.util.ResourceLoaderAware.", (Object)cName);
            }
            if (obj instanceof org.apache.lucene.analysis.util.ResourceLoaderAware) {
                this.assertAwareCompatibility(org.apache.lucene.analysis.util.ResourceLoaderAware.class, obj);
                this.waitingForResources.add((org.apache.lucene.analysis.util.ResourceLoaderAware)obj);
            }
            if (obj instanceof SolrInfoMBean) {
                this.infoMBeans.add((SolrInfoMBean)obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(SolrCore core) {
        this.dataDir = core.getDataDir();
        while (this.waitingForCore.size() > 0) {
            SolrCoreAware[] arr;
            List<SolrCoreAware> list = this.waitingForCore;
            synchronized (list) {
                arr = this.waitingForCore.toArray(new SolrCoreAware[this.waitingForCore.size()]);
                this.waitingForCore.clear();
            }
            for (SolrCoreAware aware : arr) {
                aware.inform(core);
            }
        }
        this.live = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(ResourceLoader loader) throws IOException {
        while (this.waitingForResources.size() > 0) {
            org.apache.lucene.analysis.util.ResourceLoaderAware[] arr;
            List<org.apache.lucene.analysis.util.ResourceLoaderAware> list = this.waitingForResources;
            synchronized (list) {
                arr = this.waitingForResources.toArray(new org.apache.lucene.analysis.util.ResourceLoaderAware[this.waitingForResources.size()]);
                this.waitingForResources.clear();
            }
            for (org.apache.lucene.analysis.util.ResourceLoaderAware aware : arr) {
                aware.inform((org.apache.lucene.analysis.util.ResourceLoader)loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(Map<String, SolrInfoMBean> infoRegistry) {
        SolrInfoMBean[] arr;
        List<SolrInfoMBean> list = this.infoMBeans;
        synchronized (list) {
            arr = this.infoMBeans.toArray(new SolrInfoMBean[this.infoMBeans.size()]);
            this.waitingForResources.clear();
        }
        for (SolrInfoMBean bean : arr) {
            try {
                infoRegistry.put(bean.getName(), bean);
            }
            catch (Throwable t) {
                log.warn("could not register MBean '" + bean.getName() + "'.", t);
            }
        }
    }

    public static String locateSolrHome() {
        String prop;
        String home = null;
        try {
            InitialContext c = new InitialContext();
            home = (String)c.lookup("java:comp/env/solr/home");
            log.info("Using JNDI solr.home: " + home);
        }
        catch (NoInitialContextException e) {
            log.info("JNDI not configured for solr (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.info("No /solr/home in JNDI");
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        if (home == null && (home = System.getProperty(prop = "solr.solr.home")) != null) {
            log.info("using system property " + prop + ": " + home);
        }
        if (home == null) {
            home = "solr/";
            log.info("solr home defaulted to '" + home + "' (could not find system property or JNDI)");
        }
        return SolrResourceLoader.normalizeDir(home);
    }

    public String getInstanceDir() {
        return this.instanceDir;
    }

    void assertAwareCompatibility(Class aware, Object obj) {
        Class[] valid = awareCompatibility.get(aware);
        if (valid == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Aware interface: " + aware);
        }
        for (Class v : valid) {
            if (!v.isInstance(obj)) continue;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid 'Aware' object: ").append(obj);
        builder.append(" -- ").append(aware.getName());
        builder.append(" must be an instance of: ");
        for (Class v : valid) {
            builder.append("[").append(v.getName()).append("] ");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, builder.toString());
    }

    static {
        awareCompatibility.put(SolrCoreAware.class, new Class[]{SolrRequestHandler.class, QueryResponseWriter.class, SearchComponent.class, UpdateRequestProcessorFactory.class, ShardHandlerFactory.class});
        awareCompatibility.put(org.apache.lucene.analysis.util.ResourceLoaderAware.class, new Class[]{CharFilterFactory.class, TokenFilterFactory.class, TokenizerFactory.class, QParserPlugin.class, FieldType.class});
    }
}

