/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoreMaps;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.logging.log4j.Log4jWatcher;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.PropertiesUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class CoreContainer {
    private static final String LEADER_VOTE_WAIT = "180000";
    private static final int CORE_LOAD_THREADS = 3;
    private static final String DEFAULT_HOST_CONTEXT = "solr";
    private static final String DEFAULT_HOST_PORT = "8983";
    private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 15000;
    public static final String DEFAULT_DEFAULT_CORE_NAME = "collection1";
    private static final boolean DEFAULT_SHARE_SCHEMA = false;
    protected static Logger log = LoggerFactory.getLogger(CoreContainer.class);
    private final CoreMaps coreMaps = new CoreMaps(this);
    protected final Map<String, Exception> coreInitFailures = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean persistent = false;
    protected String adminPath = null;
    protected String managementPath = null;
    protected String hostPort;
    protected String hostContext;
    protected String host;
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    protected File configFile = null;
    protected String libDir = null;
    protected SolrResourceLoader loader = null;
    protected Properties containerProperties;
    protected Map<String, IndexSchema> indexSchemaCache;
    protected String adminHandler;
    protected boolean shareSchema;
    protected Integer zkClientTimeout;
    protected String solrHome;
    protected String defaultCoreName = null;
    private ZkController zkController;
    private SolrZkServer zkServer;
    private ShardHandlerFactory shardHandlerFactory;
    protected LogWatcher logging = null;
    private String zkHost;
    private int transientCacheSize = Integer.MAX_VALUE;
    private String leaderVoteWait = "180000";
    private int distribUpdateConnTimeout = 0;
    private int distribUpdateSoTimeout = 0;
    private int coreLoadThreads;
    private CloserThread backgroundCloser = null;
    private volatile boolean isShutDown;
    volatile ConfigSolr cfg;

    @Deprecated
    public CoreContainer() {
        this(SolrResourceLoader.locateSolrHome());
    }

    public CoreContainer(String dir, File configFile) throws FileNotFoundException {
        this(dir);
        this.load(dir, configFile);
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(loader.getInstanceDir());
        this.loader = loader;
    }

    public CoreContainer(String solrHome) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = solrHome;
    }

    protected void initZooKeeper(String zkHost, int zkClientTimeout) {
        String zookeeperHost = zkHost == null ? System.getProperty("zkHost") : zkHost;
        String zkRun = System.getProperty("zkRun");
        if (zkRun == null && zookeeperHost == null) {
            return;
        }
        if (null == this.hostPort) {
            log.warn("Solr 'hostPort' has not be explicitly configured, using hardcoded default of 8983.  This default has been deprecated and will be removed in future versions of Solr, please configure this value explicitly");
            this.hostPort = DEFAULT_HOST_PORT;
        }
        if (null == this.hostContext) {
            log.warn("Solr 'hostContext' has not be explicitly configured, using hardcoded default of solr.  This default has been deprecated and will be removed in future versions of Solr, please configure this value explicitly");
            this.hostContext = DEFAULT_HOST_CONTEXT;
        }
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        if (zkRun != null) {
            String zkDataHome = System.getProperty("zkServerDataDir", this.solrHome + "zoo_data");
            String zkConfHome = System.getProperty("zkServerConfDir", this.solrHome);
            this.zkServer = new SolrZkServer(zkRun, zookeeperHost, zkDataHome, zkConfHome, this.hostPort);
            this.zkServer.parseConfig();
            this.zkServer.start();
            if (zookeeperHost == null) {
                zookeeperHost = this.zkServer.getClientString();
            }
        }
        int zkClientConnectTimeout = 15000;
        if (zookeeperHost != null) {
            try {
                if (zkRun != null && this.zkServer.getServers().size() > 1) {
                    zkClientConnectTimeout = 86400000;
                    log.info("Zookeeper client=" + zookeeperHost + "  Waiting for a quorum.");
                } else {
                    log.info("Zookeeper client=" + zookeeperHost);
                }
                String confDir = System.getProperty("bootstrap_confdir");
                boolean boostrapConf = Boolean.getBoolean("bootstrap_conf");
                if (!ZkController.checkChrootPath(zookeeperHost, confDir != null || boostrapConf)) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A chroot was specified in ZkHost but the znode doesn't exist. ");
                }
                this.zkController = new ZkController(this, zookeeperHost, zkClientTimeout, zkClientConnectTimeout, this.host, this.hostPort, this.hostContext, this.leaderVoteWait, this.distribUpdateConnTimeout, this.distribUpdateSoTimeout, new CurrentCoreDescriptorProvider(){

                    @Override
                    public List<CoreDescriptor> getCurrentDescriptors() {
                        ArrayList<CoreDescriptor> descriptors = new ArrayList<CoreDescriptor>(CoreContainer.this.getCoreNames().size());
                        for (SolrCore core : CoreContainer.this.getCores()) {
                            descriptors.add(core.getCoreDescriptor());
                        }
                        return descriptors;
                    }
                });
                if (zkRun != null && this.zkServer.getServers().size() > 1 && confDir == null && !boostrapConf) {
                    Thread.sleep(10000L);
                }
                if (confDir != null) {
                    File dir = new File(confDir);
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("bootstrap_confdir must be a directory of configuration files");
                    }
                    String confName = System.getProperty("collection.configName", "configuration1");
                    this.zkController.uploadConfigDir(dir, confName);
                }
                if (boostrapConf) {
                    ZkController.bootstrapConf(this.zkController.getZkClient(), this.cfg, this.solrHome);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Could not connect to ZooKeeper", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String dir, File configFile) throws FileNotFoundException {
        this.configFile = configFile;
        FileInputStream in = new FileInputStream(configFile);
        try {
            this.load(dir, in, configFile.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String dir, InputStream is, String fileName) {
        ConfigSolrXml cfg;
        ThreadPoolExecutor coreLoadExecutor = null;
        if (null == dir) {
            dir = SolrResourceLoader.locateSolrHome();
        }
        log.info("Loading CoreContainer using Solr Home: '{}'", (Object)dir);
        this.loader = new SolrResourceLoader(dir);
        this.solrHome = this.loader.getInstanceDir();
        try {
            cfg = new ConfigSolrXml(this.loader, null, is, null, false, this);
            this.cfg = new ConfigSolrXml(this.loader, cfg, this);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        cfg.substituteProperties();
        this.libDir = cfg.get(ConfigSolr.CfgProp.SOLR_SHAREDLIB, null);
        if (this.libDir != null) {
            File f = FileUtils.resolvePath(new File(dir), this.libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.loader.addToClassLoader(this.libDir);
            this.loader.reloadLuceneSPI();
        }
        this.shardHandlerFactory = cfg.initShardHandler();
        this.coreMaps.allocateLazyCores(cfg, this.loader);
        if (cfg.getBool(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, true)) {
            String slf4jImpl = null;
            String fname = cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, null);
            try {
                slf4jImpl = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
                if (fname == null) {
                    if (slf4jImpl.indexOf("Log4j") > 0) {
                        fname = "Log4j";
                    } else if (slf4jImpl.indexOf("JDK") > 0) {
                        fname = "JUL";
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("Unable to read SLF4J version.  LogWatcher will be disabled: " + ex);
            }
            if (fname != null) {
                if ("JUL".equalsIgnoreCase(fname)) {
                    this.logging = new JulWatcher(slf4jImpl);
                } else if ("Log4j".equals(fname)) {
                    this.logging = new Log4jWatcher(slf4jImpl);
                } else {
                    try {
                        this.logging = this.loader.newInstance(fname, LogWatcher.class);
                    }
                    catch (Throwable e) {
                        log.warn("Unable to load LogWatcher", e);
                    }
                }
                if (this.logging != null) {
                    ListenerConfig v = new ListenerConfig();
                    v.size = cfg.getInt(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, 50);
                    v.threshold = cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, null);
                    if (v.size > 0) {
                        log.info("Registering Log Listener");
                        this.logging.registerListener(v, this);
                    }
                }
            }
        }
        if (!cfg.is50OrLater()) {
            String dcoreName = cfg.get(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, null);
            if (dcoreName != null && !dcoreName.isEmpty()) {
                this.defaultCoreName = dcoreName;
            }
            this.persistent = cfg.getBool(ConfigSolr.CfgProp.SOLR_PERSISTENT, false);
            this.adminPath = cfg.get(ConfigSolr.CfgProp.SOLR_ADMINPATH, "/admin/cores");
        } else {
            this.adminPath = "/admin/cores";
        }
        this.zkHost = cfg.get(ConfigSolr.CfgProp.SOLR_ZKHOST, null);
        this.coreLoadThreads = cfg.getInt(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, 3);
        this.shareSchema = cfg.getBool(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, false);
        this.zkClientTimeout = cfg.getInt(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, 15000);
        this.distribUpdateConnTimeout = cfg.getInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, 0);
        this.distribUpdateSoTimeout = cfg.getInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, 0);
        this.hostPort = cfg.get(ConfigSolr.CfgProp.SOLR_HOSTPORT, null);
        this.hostContext = cfg.get(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, null);
        this.host = cfg.get(ConfigSolr.CfgProp.SOLR_HOST, null);
        this.leaderVoteWait = cfg.get(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, LEADER_VOTE_WAIT);
        this.adminHandler = cfg.get(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, null);
        this.managementPath = cfg.get(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, null);
        this.transientCacheSize = cfg.getInt(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
        if (this.shareSchema) {
            this.indexSchemaCache = new ConcurrentHashMap<String, IndexSchema>();
        }
        this.zkClientTimeout = Integer.parseInt(System.getProperty("zkClientTimeout", Integer.toString(this.zkClientTimeout)));
        this.initZooKeeper(this.zkHost, this.zkClientTimeout);
        if (this.isZooKeeperAware() && this.coreLoadThreads <= 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 in solr.xml for coreLoadThreads");
        }
        if (this.adminPath != null) {
            this.coreAdminHandler = this.adminHandler == null ? new CoreAdminHandler(this) : this.createMultiCoreHandler(this.adminHandler);
        }
        this.collectionsHandler = new CollectionsHandler(this);
        this.containerProperties = cfg.getSolrProperties(DEFAULT_HOST_CONTEXT);
        coreLoadExecutor = new ThreadPoolExecutor(this.coreLoadThreads, this.coreLoadThreads, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultSolrThreadFactory("coreLoadExecutor"));
        try {
            ExecutorCompletionService<SolrCore> completionService = new ExecutorCompletionService<SolrCore>(coreLoadExecutor);
            HashSet<Future<SolrCore>> pending = new HashSet<Future<SolrCore>>();
            List<String> allCores = cfg.getAllCoreNames();
            for (String oneCoreName : allCores) {
                try {
                    String rawName = cfg.getProperty(oneCoreName, "name", null);
                    if (null == rawName) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each core in solr.xml must have a 'name'");
                    }
                    final String name = rawName;
                    final CoreDescriptor p = new CoreDescriptor(this, name, cfg.getProperty(oneCoreName, "instanceDir", null));
                    String opt = cfg.getProperty(oneCoreName, "config", null);
                    if (opt != null) {
                        p.setConfigName(opt);
                    }
                    if ((opt = cfg.getProperty(oneCoreName, "schema", null)) != null) {
                        p.setSchemaName(opt);
                    }
                    if (this.zkController != null) {
                        opt = cfg.getProperty(oneCoreName, "shard", null);
                        if (opt != null && opt.length() > 0) {
                            p.getCloudDescriptor().setShardId(opt);
                        }
                        if ((opt = cfg.getProperty(oneCoreName, "collection", null)) != null) {
                            p.getCloudDescriptor().setCollectionName(opt);
                        }
                        if ((opt = cfg.getProperty(oneCoreName, "roles", null)) != null) {
                            p.getCloudDescriptor().setRoles(opt);
                        }
                        if ((opt = cfg.getProperty(oneCoreName, "coreNodeName", null)) != null && opt.length() > 0) {
                            p.getCloudDescriptor().setCoreNodeName(opt);
                        }
                    }
                    if ((opt = cfg.getProperty(oneCoreName, "properties", null)) != null) {
                        p.setPropertiesName(opt);
                    }
                    if ((opt = cfg.getProperty(oneCoreName, "dataDir", null)) != null) {
                        p.setDataDir(opt);
                    }
                    p.setCoreProperties(cfg.readCoreProperties(oneCoreName));
                    opt = cfg.getProperty(oneCoreName, "loadOnStartup", null);
                    if (opt != null) {
                        p.setLoadOnStartup("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if ((opt = cfg.getProperty(oneCoreName, "transient", null)) != null) {
                        p.setTransient("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if (p.isLoadOnStartup()) {
                        Callable<SolrCore> task = new Callable<SolrCore>(){

                            @Override
                            public SolrCore call() {
                                SolrCore c;
                                block2: {
                                    c = null;
                                    try {
                                        c = CoreContainer.this.create(p);
                                        CoreContainer.this.registerCore(p.isTransient(), name, c, false);
                                    }
                                    catch (Throwable t) {
                                        SolrException.log((Logger)log, null, (Throwable)t);
                                        if (c == null) break block2;
                                        c.close();
                                    }
                                }
                                return c;
                            }
                        };
                        pending.add(completionService.submit(task));
                        continue;
                    }
                    this.coreMaps.putDynamicDescriptor(rawName, p);
                }
                catch (Throwable ex) {
                    SolrException.log((Logger)log, null, (Throwable)ex);
                }
            }
            while (pending != null && pending.size() > 0) {
                Future future;
                block53: {
                    try {
                        future = completionService.take();
                        if (future != null) break block53;
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted while loading core", (Throwable)e);
                    }
                }
                pending.remove(future);
                try {
                    SolrCore c = (SolrCore)future.get();
                    if (c == null) continue;
                    this.coreMaps.putCoreToOrigName(c, c.getName());
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"Error loading core", (Throwable)e);
                }
            }
            this.backgroundCloser = new CloserThread(this, this.coreMaps, cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (coreLoadExecutor != null) {
                ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
    }

    protected void initShardHandler() {
        if (this.cfg != null) {
            this.cfg.initShardHandler();
        } else {
            HttpShardHandlerFactory fac = new HttpShardHandlerFactory();
            this.shardHandlerFactory = fac;
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        if (this.isZooKeeperAware()) {
            try {
                this.zkController.publishAndWaitForDownStates();
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("", (Throwable)e);
            }
        }
        this.isShutDown = true;
        if (this.isZooKeeperAware()) {
            this.coreMaps.publishCoresAsDown(this.zkController);
            this.cancelCoreRecoveries();
        }
        try {
            block20: {
                Object e = this.coreMaps.getLocker();
                synchronized (e) {
                    this.coreMaps.getLocker().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block20;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.coreMaps.clearMaps(this.cfg);
            Object object = this.coreMaps.getLocker();
            synchronized (object) {
                this.coreMaps.getLocker().notifyAll();
            }
        }
        finally {
            if (this.shardHandlerFactory != null) {
                this.shardHandlerFactory.close();
            }
            if (this.zkController != null) {
                this.zkController.close();
            }
            if (this.zkServer != null) {
                this.zkServer.stop();
            }
        }
    }

    public void cancelCoreRecoveries() {
        ArrayList<SolrCoreState> coreStates = new ArrayList<SolrCoreState>();
        this.coreMaps.addCoresToList(coreStates);
        for (SolrCoreState coreState : coreStates) {
            try {
                coreState.cancelRecovery();
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not shutdown prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore registerCore(boolean isTransientCore, String name, SolrCore core, boolean returnPrevNotClosed) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        if (this.zkController != null) {
            try {
                this.zkController.preRegister(core);
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        SolrCore old = null;
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been shutdown");
        }
        old = isTransientCore ? this.coreMaps.putTransientCore(this.cfg, name, core, this.loader) : this.coreMaps.putCore(name, core);
        core.setName(name);
        core.getCoreDescriptor().putProperty("name", name);
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            this.registerInZk(core);
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrevNotClosed) {
            old.close();
        }
        this.registerInZk(core);
        return old;
    }

    private void registerInZk(SolrCore core) {
        if (this.zkController != null) {
            try {
                this.zkController.register(core.getName(), core.getCoreDescriptor());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                try {
                    this.zkController.publish(core.getCoreDescriptor(), "down");
                }
                catch (KeeperException e1) {
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    public SolrCore register(SolrCore core, boolean returnPrev) {
        return this.registerCore(false, core.getName(), core, returnPrev);
    }

    public SolrCore register(String name, SolrCore core, boolean returnPrev) {
        return this.registerCore(false, name, core, returnPrev);
    }

    private SolrCore createFromZk(String instanceDir, CoreDescriptor dcore) {
        try {
            ZkSolrResourceLoader solrLoader = null;
            SolrConfig config = null;
            String zkConfigName = null;
            String collection = dcore.getCloudDescriptor().getCollectionName();
            this.zkController.createCollectionZkNode(dcore.getCloudDescriptor());
            zkConfigName = this.zkController.readConfigName(collection);
            if (zkConfigName == null) {
                log.error("Could not find config name for collection:" + collection);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find config name for collection:" + collection);
            }
            solrLoader = new ZkSolrResourceLoader(instanceDir, zkConfigName, this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir, dcore), this.zkController);
            config = this.getSolrConfigFromZk(zkConfigName, dcore.getConfigName(), solrLoader);
            IndexSchema schema = IndexSchemaFactory.buildIndexSchema(dcore.getSchemaName(), config);
            return new SolrCore(dcore.getName(), null, config, schema, dcore);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private SolrCore createFromLocal(String instanceDir, CoreDescriptor dcore) {
        SolrCore core;
        SolrResourceLoader solrLoader = null;
        SolrConfig config = null;
        solrLoader = new SolrResourceLoader(instanceDir, this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir, dcore));
        try {
            config = new SolrConfig(solrLoader, dcore.getConfigName(), null);
        }
        catch (Exception e) {
            log.error("Failed to load file {}", (Object)new File(instanceDir, dcore.getConfigName()).getAbsolutePath());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load config for " + dcore.getConfigName(), (Throwable)e);
        }
        IndexSchema schema = null;
        if (this.indexSchemaCache != null) {
            File schemaFile = new File(dcore.getSchemaName());
            if (!schemaFile.isAbsolute()) {
                schemaFile = new File(solrLoader.getInstanceDir() + "conf" + File.separator + dcore.getSchemaName());
            }
            if (schemaFile.exists()) {
                String key = schemaFile.getAbsolutePath() + ":" + new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT).format(new Date(schemaFile.lastModified()));
                schema = this.indexSchemaCache.get(key);
                if (schema == null) {
                    log.info("creating new schema object for core: " + dcore.getProperty("name"));
                    schema = IndexSchemaFactory.buildIndexSchema(dcore.getSchemaName(), config);
                    this.indexSchemaCache.put(key, schema);
                } else {
                    log.info("re-using schema object for core: " + dcore.getProperty("name"));
                }
            }
        }
        if (schema == null) {
            schema = IndexSchemaFactory.buildIndexSchema(dcore.getSchemaName(), config);
        }
        if ((core = new SolrCore(dcore.getName(), null, config, schema, dcore)).getUpdateHandler().getUpdateLog() != null) {
            core.getUpdateHandler().getUpdateLog().recoverFromLog();
        }
        return core;
    }

    public SolrCore create(CoreDescriptor dcore) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has shutdown.");
        }
        String name = dcore.getName();
        try {
            File idir = new File(dcore.getInstanceDir());
            String instanceDir = idir.getPath();
            log.info("Creating SolrCore '{}' using instanceDir: {}", (Object)dcore.getName(), (Object)instanceDir);
            SolrCore created = null;
            created = this.zkController != null ? this.createFromZk(instanceDir, dcore) : this.createFromLocal(instanceDir, dcore);
            this.coreMaps.addCreated(created);
            return created;
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
    }

    public Collection<SolrCore> getCores() {
        return this.coreMaps.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.coreMaps.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.coreMaps.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.coreMaps.getAllCoreNames();
    }

    public String checkUniqueDataDir(String targetPath) {
        return this.coreMaps.checkUniqueDataDir(targetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> getCoreInitFailures() {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, Exception>(this.coreInitFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) {
        try {
            String badMsg;
            name = this.checkDefault(name);
            if (this.cfg != null && (badMsg = this.cfg.getBadConfigCoreMessage(name)) != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, badMsg);
            }
            SolrCore core = this.coreMaps.getCore(name);
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
            }
            try {
                SolrResourceLoader solrLoader;
                this.coreMaps.waitAddPendingCoreOps(name);
                CoreDescriptor cd = core.getCoreDescriptor();
                File instanceDir = new File(cd.getInstanceDir());
                log.info("Reloading SolrCore '{}' using instanceDir: {}", (Object)cd.getName(), (Object)instanceDir.getAbsolutePath());
                if (this.zkController == null) {
                    solrLoader = new SolrResourceLoader(instanceDir.getAbsolutePath(), this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir.getAbsolutePath(), cd));
                } else {
                    try {
                        String collection = cd.getCloudDescriptor().getCollectionName();
                        this.zkController.createCollectionZkNode(cd.getCloudDescriptor());
                        String zkConfigName = this.zkController.readConfigName(collection);
                        if (zkConfigName == null) {
                            log.error("Could not find config name for collection:" + collection);
                            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find config name for collection:" + collection);
                        }
                        solrLoader = new ZkSolrResourceLoader(instanceDir.getAbsolutePath(), zkConfigName, this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir.getAbsolutePath(), cd), this.zkController);
                    }
                    catch (KeeperException e) {
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                }
                SolrCore newCore = core.reload(solrLoader, core);
                this.coreMaps.removeCoreToOrigName(newCore, core);
                this.registerCore(false, name, newCore, false);
            }
            finally {
                this.coreMaps.removeFromPendingOps(name);
            }
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to reload core: " + name, ex);
        }
    }

    private String checkDefault(String name) {
        return null == name || name.isEmpty() ? this.defaultCoreName : name;
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        n0 = this.checkDefault(n0);
        n1 = this.checkDefault(n1);
        this.coreMaps.swap(n0, n1);
        log.info("swapped: " + n0 + " with " + n1);
    }

    public SolrCore remove(String name) {
        name = this.checkDefault(name);
        return this.coreMaps.remove(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String name, String toName) {
        SolrCore core = this.getCore(name);
        try {
            if (core != null) {
                this.registerCore(false, toName, core, false);
                name = this.checkDefault(name);
                this.coreMaps.remove(name, false);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    public SolrCore getCore(String name) {
        String badMsg;
        name = this.checkDefault(name);
        if (this.cfg != null && (badMsg = this.cfg.getBadConfigCoreMessage(name)) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, badMsg);
        }
        SolrCore core = this.coreMaps.getCoreFromAnyList(name);
        if (core != null) {
            core.open();
            return core;
        }
        CoreDescriptor desc = this.coreMaps.getDynamicDescriptor(name);
        if (desc == null) {
            Exception e = this.getCoreInitFailures().get(name);
            if (null != e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        core = this.coreMaps.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                core = this.create(desc);
                core.open();
                this.registerCore(desc.isTransient(), name, core, false);
            } else {
                core.open();
            }
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
        finally {
            this.coreMaps.removeFromPendingOps(name);
        }
        return core;
    }

    protected CoreAdminHandler createMultiCoreHandler(String adminHandlerClass) {
        return this.loader.newAdminHandlerInstance(this, adminHandlerClass, new String[0]);
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getHostContext() {
        return this.hostContext;
    }

    public String getHost() {
        return this.host;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public void setManagementPath(String path) {
        this.managementPath = path;
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public void setLogging(LogWatcher v) {
        this.logging = v;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public boolean isLoaded(String name) {
        return this.coreMaps.isLoaded(name);
    }

    public void persist() {
        this.persistFile(null);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.coreMaps.getUnloadedCoreDescriptor(cname);
    }

    public void persistFile(File file) {
        if (this.cfg != null && this.cfg.is50OrLater()) {
            return;
        }
        log.info("Persisting cores config to " + (file == null ? this.configFile : file));
        HashMap<String, String> rootSolrAttribs = new HashMap<String, String>();
        if (this.libDir != null) {
            rootSolrAttribs.put("sharedLib", this.libDir);
        }
        rootSolrAttribs.put("persistent", Boolean.toString(this.isPersistent()));
        HashMap<String, String> coresAttribs = new HashMap<String, String>();
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ADMINPATH, "adminPath", this.adminPath, null);
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ADMINHANDLER, "adminHandler", this.adminHandler, null);
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_SHARESCHEMA, "shareSchema", Boolean.toString(this.shareSchema), Boolean.toString(false));
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOST, "host", this.host, null);
        if (null != this.defaultCoreName && !this.defaultCoreName.equals("")) {
            coresAttribs.put("defaultCoreName", this.defaultCoreName);
        }
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOSTPORT, "hostPort", this.hostPort, DEFAULT_HOST_PORT);
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, "zkClientTimeout", this.intToString(this.zkClientTimeout), Integer.toString(15000));
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, "hostContext", this.hostContext, DEFAULT_HOST_CONTEXT);
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, "leaderVoteWait", this.leaderVoteWait, LEADER_VOTE_WAIT);
        this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, "coreLoadThreads", Integer.toString(this.coreLoadThreads), Integer.toString(3));
        if (this.transientCacheSize != Integer.MAX_VALUE) {
            this.addCoresAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, "transientCacheSize", Integer.toString(this.transientCacheSize), Integer.toString(Integer.MAX_VALUE));
        }
        this.coreMaps.persistCores(this.cfg, this.containerProperties, rootSolrAttribs, coresAttribs, file, this.configFile, this.loader);
    }

    private String intToString(Integer integer) {
        if (integer == null) {
            return null;
        }
        return Integer.toString(integer);
    }

    private void addCoresAttrib(Map<String, String> coresAttribs, ConfigSolr.CfgProp prop, String attribName, String attribValue, String defaultValue) {
        if (this.cfg == null) {
            coresAttribs.put(attribName, attribValue);
            return;
        }
        if (attribValue != null) {
            String origValue = this.cfg.getOrigProp(prop, null);
            if (origValue == null && defaultValue != null && attribValue.equals(defaultValue)) {
                return;
            }
            if (attribValue.equals(PropertiesUtil.substituteProperty(origValue, this.loader.getCoreProperties()))) {
                coresAttribs.put(attribName, origValue);
            } else {
                coresAttribs.put(attribName, attribValue);
            }
        }
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkController != null;
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public boolean isShareSchema() {
        return this.shareSchema;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    private SolrConfig getSolrConfigFromZk(String zkConfigName, String solrConfigFileName, SolrResourceLoader resourceLoader) {
        return this.cfg.getSolrConfigFromZk(this.zkController, zkConfigName, solrConfigFileName, resourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrException recordAndThrow(String name, String msg, Exception ex) {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
            this.coreInitFailures.put(name, ex);
        }
        log.error(msg, (Throwable)ex);
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)ex);
    }

    String getCoreToOrigName(SolrCore core) {
        return this.coreMaps.getCoreToOrigName(core);
    }

    public String getBadCoreMessage(String name) {
        return this.cfg.getBadConfigCoreMessage(name);
    }

    public static class Initializer {
        protected String containerConfigFilename = null;
        protected String dataDir = null;

        public CoreContainer initialize() throws FileNotFoundException {
            CoreContainer cores = null;
            String solrHome = SolrResourceLoader.locateSolrHome();
            File fconf = new File(solrHome, this.containerConfigFilename == null ? "solr.xml" : this.containerConfigFilename);
            log.info("looking for solr config file: " + fconf.getAbsolutePath());
            cores = new CoreContainer(solrHome);
            if (fconf.exists()) {
                cores.load(solrHome, fconf);
            } else {
                log.info("no solr.xml found. using default old-style solr.xml");
                try {
                    cores.load(solrHome, new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>".getBytes("UTF-8")), null);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreContainer.Initialize failed when trying to load default solr.xml file", (Throwable)e);
                }
                cores.configFile = fconf;
            }
            this.containerConfigFilename = cores.getConfigFile().getName();
            return cores;
        }
    }
}

