/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.codahale.metrics.Meter;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TryRulesBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("tryRules");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new TryRules(this, config, parent, child, context);
    }

    private static final class TryRules
    extends AbstractCommand {
        private final List<Command> childRules = new ArrayList<Command>();
        private final boolean throwExceptionIfAllRulesFailed;
        private final boolean catchExceptions;
        private final boolean copyRecords;
        private final Meter numExceptionsCaught;

        public TryRules(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.throwExceptionIfAllRulesFailed = this.getConfigs().getBoolean(config, "throwExceptionIfAllRulesFailed", true);
            this.catchExceptions = this.getConfigs().getBoolean(config, "catchExceptions", false);
            this.copyRecords = this.getConfigs().getBoolean(config, "copyRecords", true);
            List<? extends Config> ruleConfigs = this.getConfigs().getConfigList(config, "rules", Collections.EMPTY_LIST);
            for (Config config2 : ruleConfigs) {
                List<Command> commands = this.buildCommandChain(config2, "commands", child, true);
                if (commands.size() <= 0) continue;
                this.childRules.add(commands.get(0));
            }
            this.validateArguments();
            this.numExceptionsCaught = this.getMeter("numExceptionsCaught");
        }

        @Override
        protected void doNotify(Record notification) {
            for (Command childRule : this.childRules) {
                childRule.notify(notification);
            }
            super.doNotify(notification);
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Command childRule : this.childRules) {
                Record copy;
                Record record2 = copy = this.copyRecords ? record.copy() : record;
                if (!this.catchExceptions) {
                    if (!childRule.process(copy)) continue;
                    return true;
                }
                try {
                    if (!childRule.process(copy)) continue;
                    return true;
                }
                catch (RuntimeException e) {
                    this.numExceptionsCaught.mark();
                    this.LOG.warn("tryRules command caught rule exception. Continuing to try other remaining rules", (Throwable)e);
                }
            }
            this.LOG.warn("tryRules command found no successful rule");
            if (this.throwExceptionIfAllRulesFailed) {
                throw new MorphlineRuntimeException("tryRules command found no successful rule for record: " + record);
            }
            return false;
        }
    }
}

