/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Configs;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public final class TranslateBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("translate");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Translate(this, config, parent, child, context);
    }

    private static final class Translate
    extends AbstractCommand {
        private final String fieldName;
        private final Map<String, Object> dictionary = new HashMap<String, Object>();
        private final Object fallback;

        public Translate(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, "field");
            Config dict = this.getConfigs().getConfig(config, "dictionary");
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(dict)) {
                this.dictionary.put(entry.getKey(), entry.getValue());
            }
            this.fallback = this.getConfigs().getString(config, "fallback", null);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            ListIterator<Object> iter = record.get(this.fieldName).listIterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                Object value = this.dictionary.get(key);
                if (value != null) {
                    iter.set(value);
                    continue;
                }
                if (this.fallback != null) {
                    iter.set(this.fallback);
                    continue;
                }
                this.LOG.debug("No match found for key: {}", (Object)key);
                return false;
            }
            return super.doProcess(record);
        }
    }
}

