/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.google.common.base.Charsets;
import com.typesafe.config.Config;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;

public final class ToByteArrayBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("toByteArray");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToByteArray(this, config, parent, child, context);
    }

    private static final class ToByteArray
    extends AbstractCommand {
        private final String fieldName;
        private final Charset charset;

        public ToByteArray(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, "field");
            this.charset = this.getConfigs().getCharset(config, "charset", Charsets.UTF_8);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            ListIterator iter = record.get(this.fieldName).listIterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (value instanceof byte[]) continue;
                String str = value.toString();
                value = str.getBytes(this.charset);
                iter.set(value);
            }
            return super.doProcess(record);
        }
    }
}

