/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.stdlib.GrokDictionaries;
import com.google.common.base.Splitter;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class SplitBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("split");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Split(this, config, parent, child, context);
    }

    private static final class Split
    extends AbstractCommand {
        private final String inputFieldName;
        private final String outputFieldName;
        private final List<String> outputFieldNames;
        private final boolean addEmptyStrings;
        private final Splitter splitter;

        public Split(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldName = this.getConfigs().getString(config, "outputField", null);
            this.outputFieldNames = this.getConfigs().getStringList(config, "outputFields", null);
            if (this.outputFieldName == null && this.outputFieldNames == null) {
                throw new MorphlineCompilationException("Either outputField or outputFields must be defined", config);
            }
            if (this.outputFieldName != null && this.outputFieldNames != null) {
                throw new MorphlineCompilationException("Must not define both outputField and outputFields at the same time", config);
            }
            String separator = this.getConfigs().getString(config, "separator");
            boolean isRegex = this.getConfigs().getBoolean(config, "isRegex", false);
            GrokDictionaries dict = new GrokDictionaries(config, this.getConfigs());
            Splitter currentSplitter = isRegex ? Splitter.on((Pattern)dict.compileExpression(separator).pattern()) : (separator.length() == 1 ? Splitter.on((char)separator.charAt(0)) : Splitter.on((String)separator));
            int limit = this.getConfigs().getInt(config, "limit", -1);
            if (limit > 0) {
                currentSplitter = currentSplitter.limit(limit);
            }
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", false);
            if (this.outputFieldNames == null && !this.addEmptyStrings) {
                currentSplitter = currentSplitter.omitEmptyStrings();
            }
            if (this.getConfigs().getBoolean(config, "trim", true)) {
                currentSplitter = currentSplitter.trimResults();
            }
            this.splitter = currentSplitter;
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Object value : record.get(this.inputFieldName)) {
                Iterable columns = this.splitter.split((CharSequence)value.toString());
                if (this.outputFieldNames == null) {
                    record.getFields().putAll((Object)this.outputFieldName, columns);
                    continue;
                }
                this.extractColumns(record, columns);
            }
            return super.doProcess(record);
        }

        private void extractColumns(Record record, Iterable<String> columns) {
            Iterator<String> iter = columns.iterator();
            for (int i = 0; i < this.outputFieldNames.size() && iter.hasNext(); ++i) {
                String columnValue = iter.next();
                String columnName = this.outputFieldNames.get(i);
                if (columnName.length() <= 0 || columnValue.length() <= 0 && !this.addEmptyStrings) continue;
                record.put(columnName, columnValue);
            }
        }
    }
}

