/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.cloudera.cdk.morphline.shaded.org.apache.commons.math3.random.Well19937c;
import com.typesafe.config.Config;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;

public final class SampleBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("sample");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Sample(this, config, parent, child, context);
    }

    private static final class Sample
    extends AbstractCommand {
        private final double probability;
        private final RandomGenerator prng;
        private long count = 0L;

        public Sample(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.probability = this.getConfigs().getDouble(config, "probability", 1.0);
            if (this.probability < 0.0) {
                throw new MorphlineCompilationException("Probability must not be negative: " + this.probability, config);
            }
            if (this.probability >= 1.0) {
                this.prng = null;
            } else if (config.hasPath("seed")) {
                long seed = this.getConfigs().getLong(config, "seed");
                this.prng = new Well19937c(seed);
            } else {
                SecureRandom rand = new SecureRandom();
                int[] seed = new int[624];
                for (int i = 0; i < seed.length; ++i) {
                    seed[i] = rand.nextInt();
                }
                this.prng = new Well19937c(seed);
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.prng != null && this.prng.nextDouble() > this.probability) {
                return true;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("sampleCount: {}", (Object)this.count);
            }
            ++this.count;
            return super.doProcess(record);
        }
    }
}

