/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.shaded.org.apache.hadoop.fs.GlobPattern;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class PatternMetricFilter
implements MetricFilter {
    private final List<ExpressionPair> includes = new ArrayList<ExpressionPair>();
    private final List<ExpressionPair> excludes = new ArrayList<ExpressionPair>();

    public static MetricFilter parse(Configs configs, Config config) {
        Preconditions.checkNotNull((Object)configs);
        Preconditions.checkNotNull((Object)config);
        Config filterConfig = configs.getConfig(config, "metricFilter", null);
        if (filterConfig == null) {
            return MetricFilter.ALL;
        }
        return new PatternMetricFilter(filterConfig);
    }

    private PatternMetricFilter(Config config) {
        Configs configs = new Configs();
        Config includesConfig = configs.getConfig(config, "includes", null);
        if (includesConfig == null) {
            this.includes.add(new ExpressionPair(new MatchAllExpression(), new MatchAllExpression()));
        } else {
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(includesConfig)) {
                this.includes.add(this.parseExpressionPair(entry.getKey(), entry.getValue().toString(), includesConfig));
            }
        }
        Config excludesConfig = configs.getConfig(config, "excludes", null);
        if (excludesConfig != null) {
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(excludesConfig)) {
                this.excludes.add(this.parseExpressionPair(entry.getKey(), entry.getValue().toString(), excludesConfig));
            }
        }
        configs.validateArguments(config);
    }

    private ExpressionPair parseExpressionPair(String strA, String strB, Config config) {
        Expression exprA = this.parseExpression(strA, config);
        Expression exprB = this.parseExpression(strB, config);
        return new ExpressionPair(exprA, exprB);
    }

    private Expression parseExpression(String expr, Config config) {
        int i;
        if (expr.equals("*")) {
            expr = "glob:*";
        }
        if ((i = expr.indexOf(58)) < 0) {
            throw new MorphlineCompilationException("Illegal match expression: " + expr, config);
        }
        String type = expr.substring(0, i);
        String pattern = expr.substring(i + 1, expr.length());
        if (type.equals("literal")) {
            return new LiteralExpression(pattern);
        }
        if (type.equals("regex")) {
            if (pattern.equals(".*")) {
                return new MatchAllExpression();
            }
            return new RegexExpression(Pattern.compile(pattern));
        }
        if (type.equals("glob")) {
            if (pattern.equals("*")) {
                return new MatchAllExpression();
            }
            return new GlobExpression(pattern);
        }
        throw new MorphlineCompilationException("Illegal match type: " + type, config);
    }

    public boolean matches(String name, Metric metric) {
        ExpressionPair include;
        Preconditions.checkNotNull((Object)name);
        String className = metric.getClass().getName();
        boolean isIncluded = false;
        Iterator<ExpressionPair> i$ = this.includes.iterator();
        while (i$.hasNext() && !(isIncluded = (include = i$.next()).matches(name, className))) {
        }
        if (!isIncluded) {
            return false;
        }
        for (ExpressionPair exclude : this.excludes) {
            if (!exclude.matches(name, className)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "includes: " + this.includes + ", excludes: " + this.excludes;
    }

    public class GlobExpression
    implements Expression {
        private final Pattern regex;
        private final String pattern;

        public GlobExpression(String pattern) {
            this.pattern = pattern;
            this.regex = GlobPattern.compile(pattern);
        }

        @Override
        public boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }

        public String toString() {
            return "glob:" + this.pattern;
        }
    }

    public final class RegexExpression
    implements Expression {
        private final Pattern regex;

        public RegexExpression(Pattern pattern) {
            this.regex = pattern;
        }

        @Override
        public boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }

        public String toString() {
            return "regex:" + this.regex.pattern();
        }
    }

    public final class LiteralExpression
    implements Expression {
        private final String pattern;

        public LiteralExpression(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String str) {
            return this.pattern.equals(str);
        }

        public String toString() {
            return "literal:" + this.pattern;
        }
    }

    public final class MatchAllExpression
    implements Expression {
        @Override
        public boolean matches(String str) {
            return true;
        }

        public String toString() {
            return "all:";
        }
    }

    public static interface Expression {
        public boolean matches(String var1);
    }

    public final class ExpressionPair {
        private final Expression exprA;
        private final Expression exprB;

        public ExpressionPair(Expression exprA, Expression exprB) {
            this.exprA = exprA;
            this.exprB = exprB;
        }

        public boolean matches(String strA, String strB) {
            return this.exprA.matches(strA) && this.exprB.matches(strB);
        }

        public String toString() {
            return this.exprA.toString() + " : " + this.exprB.toString();
        }
    }
}

