/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.base.Fields;
import com.cloudera.cdk.morphline.scriptengine.java.ScriptEvaluator;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import javax.script.ScriptException;
import org.slf4j.Logger;

public final class JavaBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("java");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new Java(this, config, parent, child, context);
        }
        catch (ScriptException e) {
            throw new MorphlineCompilationException("Cannot compile script", config, e);
        }
    }

    private static final class Java
    extends AbstractCommand {
        private final ScriptEvaluator<Boolean> script;
        private static final String DEFAULT_IMPORTS = "import java.util.*;\nimport java.io.*;\nimport java.text.*;\nimport com.google.common.base.*;\nimport com.google.common.collect.*;\nimport " + Record.class.getPackage().getName() + ".*;\n" + "import " + Fields.class.getName() + ";\n" + "import " + Configs.class.getName() + ";\n" + "";

        public Java(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws ScriptException {
            super(builder, config, parent, child, context);
            String javaImports = this.getConfigs().getString(config, "imports", DEFAULT_IMPORTS);
            String javaCodeBlock = this.getConfigs().getString(config, "code");
            this.script = new ScriptEvaluator<Boolean>(javaImports, javaCodeBlock, Boolean.class, new String[]{"record", "config", "parent", "child", "context", "logger"}, new Class[]{Record.class, Config.class, Command.class, Command.class, MorphlineContext.class, Logger.class}, javaCodeBlock);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            try {
                return this.script.evaluate(record, this.getConfig(), this, this.getChild(), this.getContext(), this.LOG);
            }
            catch (ScriptException e) {
                throw new MorphlineRuntimeException("Cannot execute script", e);
            }
        }
    }
}

