/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.shaded.com.google.code.regexp.Pattern;
import com.cloudera.cdk.morphline.stdlib.AbstractFieldTransformCommand;
import com.cloudera.cdk.morphline.stdlib.GrokDictionaries;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;

public final class FindReplaceBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("findReplace");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new FindReplace(this, config, parent, child, context);
    }

    private static final class StringUtils {
        private StringUtils() {
        }

        public static String replace(String text, String searchString, String replacement, int max) {
            if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
                return text;
            }
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = text.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return buf.toString();
        }

        private static boolean isEmpty(CharSequence cs) {
            return cs == null || cs.length() == 0;
        }
    }

    private static final class FindReplace
    extends AbstractFieldTransformCommand {
        private final Matcher matcher;
        private final String literalPattern;
        private final String replacement;
        private final boolean replaceFirst;

        public FindReplace(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            GrokDictionaries dict = new GrokDictionaries(config, this.getConfigs());
            String replacementStr = this.getConfigs().getString(config, "replacement");
            String pattern = this.getConfigs().getString(config, "pattern");
            if (this.getConfigs().getBoolean(config, "isRegex", false)) {
                Pattern regex = dict.compileExpression(pattern);
                this.matcher = regex.pattern().matcher("");
                replacementStr = regex.replaceProperties(replacementStr);
                this.literalPattern = null;
            } else {
                this.matcher = null;
                this.literalPattern = pattern;
            }
            this.replacement = replacementStr;
            this.replaceFirst = this.getConfigs().getBoolean(config, "replaceFirst", false);
            this.validateArguments();
        }

        @Override
        protected Object transformFieldValue(Object value) {
            String result;
            String str = value.toString();
            if (this.literalPattern != null) {
                int max = this.replaceFirst ? 1 : -1;
                result = StringUtils.replace(str, this.literalPattern, this.replacement, max);
            } else {
                this.matcher.reset(str);
                result = this.replaceFirst ? this.matcher.replaceFirst(this.replacement) : this.matcher.replaceAll(this.replacement);
            }
            return result;
        }
    }
}

