/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;

public final class ExtractURIComponentsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("extractURIComponents");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractURIComponents(this, config, parent, child, context);
    }

    private static final class ExtractURIComponents
    extends AbstractCommand {
        private final String inputFieldName;
        private final String outputFieldPrefix;
        private final boolean failOnInvalidURI;

        public ExtractURIComponents(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldPrefix = this.getConfigs().getString(config, "outputFieldPrefix", "");
            this.failOnInvalidURI = this.getConfigs().getBoolean(config, "failOnInvalidURI", false);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Object uriObj : record.get(this.inputFieldName)) {
                URI uri;
                try {
                    uri = new URI(uriObj.toString());
                }
                catch (URISyntaxException e) {
                    this.LOG.debug("Invalid URI: {}", uriObj);
                    if (!this.failOnInvalidURI) continue;
                    return false;
                }
                this.addValue(record, "scheme", uri.getScheme());
                this.addValue(record, "authority", uri.getAuthority());
                this.addValue(record, "path", uri.getPath());
                this.addValue(record, "query", uri.getQuery());
                this.addValue(record, "fragment", uri.getFragment());
                this.addValue(record, "host", uri.getHost());
                this.addValue(record, "port", uri.getPort());
                this.addValue(record, "schemeSpecificPart", uri.getSchemeSpecificPart());
                this.addValue(record, "userInfo", uri.getUserInfo());
            }
            return super.doProcess(record);
        }

        private void addValue(Record record, String name, Object value) {
            if (value != null) {
                record.put(this.outputFieldPrefix + name, value);
            }
        }
    }
}

