/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Validator;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;

public final class ExtractURIComponentBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("extractURIComponent");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ExtractURIComponent(this, config, parent, child, context);
    }

    private static enum Component {
        scheme,
        authority,
        path,
        query,
        fragment,
        host,
        port,
        schemeSpecificPart,
        userInfo;

    }

    private static final class ExtractURIComponent
    extends AbstractCommand {
        private final String inputFieldName;
        private final String outputFieldName;
        private final boolean failOnInvalidURI;
        private final Component component;

        public ExtractURIComponent(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldName = this.getConfigs().getString(config, "outputField");
            this.failOnInvalidURI = this.getConfigs().getBoolean(config, "failOnInvalidURI", false);
            this.component = (Component)new Validator().validateEnum(config, this.getConfigs().getString(config, "component"), Component.class, new Component[0]);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            block13: for (Object uriObj : record.get(this.inputFieldName)) {
                URI uri;
                try {
                    uri = new URI(uriObj.toString());
                }
                catch (URISyntaxException e) {
                    this.LOG.debug("Invalid URI: {}", uriObj);
                    if (!this.failOnInvalidURI) continue;
                    return false;
                }
                switch (this.component) {
                    case scheme: {
                        this.addValue(record, uri.getScheme());
                        continue block13;
                    }
                    case authority: {
                        this.addValue(record, uri.getAuthority());
                        continue block13;
                    }
                    case path: {
                        this.addValue(record, uri.getPath());
                        continue block13;
                    }
                    case query: {
                        this.addValue(record, uri.getQuery());
                        continue block13;
                    }
                    case fragment: {
                        this.addValue(record, uri.getFragment());
                        continue block13;
                    }
                    case host: {
                        this.addValue(record, uri.getHost());
                        continue block13;
                    }
                    case port: {
                        this.addValue(record, uri.getPort());
                        continue block13;
                    }
                    case schemeSpecificPart: {
                        this.addValue(record, uri.getSchemeSpecificPart());
                        continue block13;
                    }
                    case userInfo: {
                        this.addValue(record, uri.getUserInfo());
                        continue block13;
                    }
                }
                throw new IllegalStateException("Illegal component: " + this.component.name());
            }
            return super.doProcess(record);
        }

        private void addValue(Record record, Object value) {
            if (value != null) {
                record.put(this.outputFieldName, value);
            }
        }
    }
}

