/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.base.FieldExpression;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ContainsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("contains");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Contains(this, config, parent, child, context);
    }

    private static final class Contains
    extends AbstractCommand {
        private final Set<Map.Entry<String, Object>> entrySet;
        private final String renderedConfig;

        public Contains(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.entrySet = new Configs().getEntrySet(config);
            this.renderedConfig = config.root().render();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Map.Entry<String, Object> entry : this.entrySet) {
                String fieldName = entry.getKey();
                List values = record.get(fieldName);
                Object entryValue = entry.getValue();
                Collection results = entryValue instanceof Collection ? (Collection)entryValue : new FieldExpression(entryValue.toString(), this.getConfig()).evaluate(record);
                boolean found = false;
                for (Object result : results) {
                    if (!values.contains(result)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Contains command failed because it could not find any of {} in values: {} for command: {}", new Object[]{results, values, this.renderedConfig});
                }
                return false;
            }
            return super.doProcess(record);
        }
    }
}

