/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.stdlib.AbstractAddValuesCommand;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class AddValuesIfAbsentBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("addValuesIfAbsent");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new AddValuesIfAbsent(this, config, parent, child, context);
    }

    private static final class AddValuesIfAbsent
    extends AbstractAddValuesCommand {
        public AddValuesIfAbsent(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
        }

        @Override
        protected void putAll(Record record, String key, Collection values) {
            List existingValues = record.get(key);
            if (values.size() <= 3) {
                for (Object value : values) {
                    if (existingValues.contains(value)) continue;
                    existingValues.add(value);
                }
            } else {
                HashSet index = new HashSet(existingValues);
                for (Object value : values) {
                    if (!index.add(value)) continue;
                    existingValues.add(value);
                }
            }
        }

        @Override
        protected void put(Record record, String key, Object value) {
            record.putIfAbsent(key, value);
        }
    }
}

