/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;

public final class ReadClobBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readClob");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadClob(this, config, parent, child, context);
    }

    private static final class ReadClob
    extends AbstractParser {
        private final Charset charset;
        private final String outputFieldName;
        private final char[] buffer = new char[8192];
        private StringBuilder clob;
        private int counter = 0;

        public ReadClob(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.outputFieldName = this.getConfigs().getString(config, "outputField", "message");
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            int len;
            if (this.counter++ % 8192 == 0) {
                this.clob = new StringBuilder();
            }
            this.incrementNumRecords();
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            this.clob.setLength(0);
            while ((len = reader.read(this.buffer)) >= 0) {
                this.clob.append(this.buffer, 0, len);
            }
            Record outputRecord = inputRecord.copy();
            ReadClob.removeAttachments(outputRecord);
            outputRecord.replaceValues(this.outputFieldName, this.clob.toString());
            return this.getChild().process(outputRecord);
        }
    }
}

