/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.fastreader.CSVTokenizer;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.fastreader.QuotedCSVTokenizer;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.fastreader.SimpleCSVTokenizer;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ReadCSVBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readCSV");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadCSV(this, config, parent, child, context);
    }

    private static final class ReadCSV
    extends AbstractParser {
        private final char separatorChar;
        private final List<String> columnNames;
        private final Charset charset;
        private final boolean ignoreFirstLine;
        private final boolean trim;
        private final boolean addEmptyStrings;
        private final String commentPrefix;
        private final String quoteChar;
        private final boolean ignoreEmptyLines = true;
        private final CSVTokenizer tokenizer;

        public ReadCSV(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String separator = this.getConfigs().getString(config, "separator", ",");
            if (separator.length() != 1) {
                throw new MorphlineCompilationException("CSV separator must be one character only: " + separator, config);
            }
            this.separatorChar = separator.charAt(0);
            this.columnNames = this.getConfigs().getStringList(config, "columns");
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.ignoreFirstLine = this.getConfigs().getBoolean(config, "ignoreFirstLine", false);
            this.trim = this.getConfigs().getBoolean(config, "trim", true);
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", true);
            this.quoteChar = this.getConfigs().getString(config, "quoteChar", "");
            if (this.quoteChar.length() > 1) {
                throw new MorphlineCompilationException("Quote character must not have a length of more than one character: " + this.quoteChar, config);
            }
            if (this.quoteChar.equals(String.valueOf(this.separatorChar))) {
                throw new MorphlineCompilationException("Quote character must not be the same as separator: " + this.quoteChar, config);
            }
            this.commentPrefix = this.getConfigs().getString(config, "commentPrefix", "");
            if (this.commentPrefix.length() > 1) {
                throw new MorphlineCompilationException("Comment prefix must not have a length of more than one character: " + this.commentPrefix, config);
            }
            this.tokenizer = this.quoteChar.length() == 0 ? new SimpleCSVTokenizer(this.separatorChar, this.trim, this.addEmptyStrings, this.columnNames) : new QuotedCSVTokenizer(this.separatorChar, this.trim, this.addEmptyStrings, this.columnNames, this.quoteChar.charAt(0));
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            Record outputRecord;
            Record template = inputRecord.copy();
            ReadCSV.removeAttachments(template);
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, detectedCharset), this.getBufferSize(stream));
            if (this.ignoreFirstLine) {
                reader.readLine();
            }
            while (this.readNext(reader, outputRecord = template.copy())) {
                this.incrementNumRecords();
                if (this.getChild().process(outputRecord)) continue;
                return false;
            }
            return true;
        }

        private boolean readNext(BufferedReader reader, Record record) throws IOException {
            String line;
            do {
                if ((line = reader.readLine()) != null) continue;
                return false;
            } while (this.isTrimmedLineEmpty(line) || this.commentPrefix.length() > 0 && line.startsWith(this.commentPrefix));
            this.tokenizer.tokenizeLine(line, reader, record);
            return true;
        }

        private boolean isTrimmedLineEmpty(String line) {
            int len = line.length();
            for (int i = 0; i < len; ++i) {
                if (line.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }
    }
}

